/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.tree;

import com.elixirtech.jdom.Element;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;

public class JDomCellRenderer
extends JLabel
implements TreeCellRenderer {
    private Icon m_Expanded;
    private Icon m_Collapsed;
    private Icon m_Leaf;
    private Color m_BackgroundSelectionColor;
    private Color m_BackgroundNonSelectionColor;
    private Color m_TextSelectionColor;
    private Color m_TextNonSelectionColor;

    public JDomCellRenderer() {
        this.setOpaque(false);
        this.loadUI();
    }

    protected void loadUI() {
        this.m_Expanded = UIManager.getIcon("Tree.openIcon");
        this.m_Collapsed = UIManager.getIcon("Tree.closedIcon");
        this.m_Leaf = UIManager.getIcon("Tree.leafIcon");
        this.m_BackgroundSelectionColor = UIManager.getColor("Tree.selectionBackground");
        this.m_BackgroundNonSelectionColor = UIManager.getColor("Tree.textBackground");
        this.m_TextSelectionColor = Color.white;
        this.m_TextNonSelectionColor = Color.black;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.setForeground(bl ? this.m_TextSelectionColor : this.m_TextNonSelectionColor);
        this.setFont(jTree.getFont());
        Element element = (Element)object;
        this.setText(this.getName(element));
        Icon icon = this.getIcon(element);
        if (icon == null) {
            icon = bl3 ? this.m_Leaf : (bl2 ? this.m_Expanded : this.m_Collapsed);
        }
        this.setIcon(icon);
        return this;
    }

    protected String getName(Element element) {
        String string = element.getAttributeValue("name");
        if (string == null || string.length() == 0) {
            string = element.getName();
        }
        return string;
    }

    protected Icon getIcon(Element element) {
        return null;
    }
}

