/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.tree;

import com.elixirtech.jdom.Element;
import com.elixirtech.ui.tree.JDomTreeModel;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class JDomTListener
implements MouseListener {
    private final JTree m_Tree;

    public JDomTListener(JTree jTree) {
        this.m_Tree = jTree;
        this.m_Tree.addMouseListener(this);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.doPopup(mouseEvent);
        } else {
            this.doSelect(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.doPopup(mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.doPopup(mouseEvent);
        } else {
            int n = mouseEvent.getClickCount();
            if (n == 2) {
                this.doDoubleClick(mouseEvent);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected void doPopup(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.m_Tree.getRowForLocation(point.x, point.y);
        TreePath treePath = this.m_Tree.getPathForLocation(point.x, point.y);
        if (n != -1) {
            Element element = (Element)treePath.getLastPathComponent();
            JPopupMenu jPopupMenu = this.getPopupMenu(element);
            if (jPopupMenu != null) {
                jPopupMenu.show(this.m_Tree, point.x, point.y);
            }
            mouseEvent.consume();
        }
    }

    protected void doSelect(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.m_Tree.getRowForLocation(point.x, point.y);
        TreePath treePath = this.m_Tree.getPathForLocation(point.x, point.y);
        if (n != -1) {
            Element element = (Element)treePath.getLastPathComponent();
            this.doSelect(element);
            mouseEvent.consume();
        }
    }

    protected void doDoubleClick(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.m_Tree.getRowForLocation(point.x, point.y);
        TreePath treePath = this.m_Tree.getPathForLocation(point.x, point.y);
        if (n != -1) {
            Element element = (Element)treePath.getLastPathComponent();
            this.doDoubleClick(element);
            mouseEvent.consume();
        }
    }

    protected JPopupMenu getPopupMenu(Element element) {
        return ((JDomTreeModel)this.m_Tree.getModel()).getPopupMenu(element);
    }

    protected void doSelect(Element element) {
        ((JDomTreeModel)this.m_Tree.getModel()).doSelect(element);
    }

    protected void doDoubleClick(Element element) {
        ((JDomTreeModel)this.m_Tree.getModel()).doDoubleClick(element);
    }
}

