/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.tree;

import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.Parent;
import com.elixirtech.jdom.input.SAXBuilder;
import com.elixirtech.jdom.output.Format;
import com.elixirtech.jdom.output.XMLOutputter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JDomTreeModel
implements TreeModel {
    protected Element m_RootNode;
    protected final List<TreeModelListener> m_Listeners = new ArrayList<TreeModelListener>();

    public JDomTreeModel() {
    }

    public JDomTreeModel(InputStream inputStream) throws IOException {
        this.load(inputStream);
    }

    public JDomTreeModel(InputStream inputStream, Resolver resolver) throws IOException {
        this.load(inputStream, resolver);
    }

    public void load(InputStream inputStream) throws IOException {
        this.load(inputStream, null);
    }

    public void load(InputStream inputStream, Resolver resolver) throws IOException {
        try {
            SAXBuilder sAXBuilder = new SAXBuilder(false);
            Document document = sAXBuilder.build(inputStream);
            this.m_RootNode = document.getRootElement();
            if (resolver != null) {
                this.processIncludes(this.m_RootNode, resolver);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("-----------------------------------");
            throw new IOException("XML Error: " + String.valueOf(exception));
        }
        this.fireStructureChangedEvent(new TreePath(this.m_RootNode));
    }

    public void write(OutputStream outputStream) throws IOException {
        XMLOutputter xMLOutputter = new XMLOutputter(Format.getCompactFormat());
        xMLOutputter.output(this.m_RootNode.getDocument(), outputStream);
    }

    protected void processIncludes(Element element, Resolver resolver) throws IOException {
        if (element.getName().equals("include")) {
            try {
                InputStream inputStream = resolver.getInputStream(element.getAttributeValue("href"));
                if (inputStream != null) {
                    SAXBuilder sAXBuilder = new SAXBuilder(false);
                    Document document = sAXBuilder.build(inputStream);
                    Element element2 = document.getRootElement();
                    Parent parent = element.getParent();
                    if (parent instanceof Element) {
                        List list = ((Element)parent).getChildren();
                        int n = list.indexOf(element);
                        list.set(n, (Element)element2.detach());
                    }
                    ((Document)parent).setRootElement((Element)element2.detach());
                }
                element.setName("error");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("-----------------------------------");
                throw new IOException("XML Error: " + String.valueOf(exception));
            }
        } else {
            List list = element.getChildren();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this.processIncludes((Element)list.get(i), resolver);
            }
        }
    }

    public void setRoot(Element element) {
        this.m_RootNode = element;
    }

    @Override
    public synchronized void addTreeModelListener(TreeModelListener treeModelListener) {
        this.m_Listeners.add(treeModelListener);
    }

    @Override
    public Object getChild(Object object, int n) {
        return this.getChildNodes(object)[n];
    }

    @Override
    public int getChildCount(Object object) {
        return ((Element)object).getChildren().size();
    }

    protected Element[] getChildNodes(Object object) {
        List list = ((Element)object).getChildren();
        Element[] elementArray = new Element[list.size()];
        list.toArray(elementArray);
        return elementArray;
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        Element[] elementArray = this.getChildNodes(object);
        for (int i = 0; i < elementArray.length; ++i) {
            if (elementArray[i] != object2) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return this.m_RootNode;
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.getChildCount(object) == 0;
    }

    @Override
    public synchronized void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.m_Listeners.remove(treeModelListener);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    protected void doSelect(Element element) {
    }

    protected void doDoubleClick(Element element) {
    }

    protected JPopupMenu getPopupMenu(Element element) {
        return null;
    }

    public TreePath getTreePath(Element element) {
        Parent parent;
        ArrayList<Element> arrayList = new ArrayList<Element>();
        while (element != null) {
            arrayList.add(0, element);
            parent = element.getParent();
            if (!(parent instanceof Element)) break;
            element = (Element)parent;
        }
        parent = new Object[arrayList.size()];
        arrayList.toArray((T[])parent);
        return new TreePath((Object[])parent);
    }

    public void fireInsertedEvent(TreePath treePath, int[] nArray, Object[] objectArray) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
        this.fireInsertedEvent(treeModelEvent);
    }

    public void fireRemovedEvent(TreePath treePath, int[] nArray, Object[] objectArray) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
        this.fireRemovedEvent(treeModelEvent);
    }

    public void fireChangedEvent(TreePath treePath, int[] nArray, Object[] objectArray) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
        this.fireChangedEvent(treeModelEvent);
    }

    public void fireInsertedEvent(TreePath treePath) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        this.fireInsertedEvent(treeModelEvent);
    }

    public void fireRemovedEvent(TreePath treePath) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        this.fireRemovedEvent(treeModelEvent);
    }

    public void fireChangedEvent(TreePath treePath) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        this.fireChangedEvent(treeModelEvent);
    }

    public void fireStructureChangedEvent(TreePath treePath) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        this.fireStructureChangedEvent(treeModelEvent);
    }

    private void fireInsertedEvent(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.m_Listeners) {
            treeModelListener.treeNodesInserted(treeModelEvent);
        }
    }

    private void fireRemovedEvent(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.m_Listeners) {
            treeModelListener.treeNodesRemoved(treeModelEvent);
        }
    }

    private void fireChangedEvent(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.m_Listeners) {
            treeModelListener.treeNodesChanged(treeModelEvent);
        }
    }

    private void fireStructureChangedEvent(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.m_Listeners) {
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
    }

    public static interface Resolver {
        public InputStream getInputStream(String var1);
    }
}

