/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.tree;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class TreeNotifier {
    private final List<TreeModelListener> m_Listeners = new ArrayList<TreeModelListener>();
    private boolean m_IsDirty;

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.m_Listeners.add(treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.m_Listeners.remove(treeModelListener);
    }

    public boolean isDirty() {
        return this.m_IsDirty;
    }

    public void setDirty(boolean bl) {
        this.m_IsDirty = bl;
    }

    public void fireInsertedEvent(TreePath treePath, int[] nArray, Object[] objectArray) {
        this.m_IsDirty = true;
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
        this.fireInsertedEvent(treeModelEvent);
    }

    public void fireRemovedEvent(TreePath treePath, int[] nArray, Object[] objectArray) {
        this.m_IsDirty = true;
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
        this.fireRemovedEvent(treeModelEvent);
    }

    public void fireChangedEvent(TreePath treePath, int[] nArray, Object[] objectArray) {
        this.m_IsDirty = true;
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
        this.fireChangedEvent(treeModelEvent);
    }

    public void fireInsertedEvent(TreePath treePath) {
        this.m_IsDirty = true;
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        this.fireInsertedEvent(treeModelEvent);
    }

    public void fireRemovedEvent(TreePath treePath) {
        this.m_IsDirty = true;
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        this.fireRemovedEvent(treeModelEvent);
    }

    public void fireChangedEvent(TreePath treePath) {
        this.m_IsDirty = true;
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        this.fireChangedEvent(treeModelEvent);
    }

    public void fireStructureChangedEvent(TreePath treePath) {
        this.m_IsDirty = true;
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        this.fireStructureChangedEvent(treeModelEvent);
    }

    private void fireInsertedEvent(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.m_Listeners) {
            treeModelListener.treeNodesInserted(treeModelEvent);
        }
    }

    private void fireRemovedEvent(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.m_Listeners) {
            treeModelListener.treeNodesRemoved(treeModelEvent);
        }
    }

    private void fireChangedEvent(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.m_Listeners) {
            treeModelListener.treeNodesChanged(treeModelEvent);
        }
    }

    private void fireStructureChangedEvent(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.m_Listeners) {
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
    }
}

