/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.tree;

import com.elixirtech.ui.tree.TreeModelEx;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeSupport
extends JLabel
implements MouseListener,
KeyListener,
TreeCellRenderer {
    protected final JTree m_Tree;
    protected Icon m_Expanded;
    protected Icon m_Collapsed;
    protected Icon m_Leaf;
    private Color m_TextSelectionColor;
    private Color m_TextNonSelectionColor;

    public TreeSupport(JTree jTree, boolean bl) {
        this.m_Tree = jTree;
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.loadUI();
        this.m_Tree.addMouseListener(this);
        this.m_Tree.addKeyListener(this);
        this.m_Tree.setCellRenderer(this);
        if (bl) {
            this.m_Tree.setCellEditor(new TCEditor());
        }
    }

    public void setLeaf(Icon icon) {
        this.m_Leaf = icon;
    }

    public void setExpanded(Icon icon) {
        this.m_Expanded = icon;
    }

    public void setCollapsed(Icon icon) {
        this.m_Collapsed = icon;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.setForeground(bl ? this.m_TextSelectionColor : this.m_TextNonSelectionColor);
        Icon icon = null;
        String string = object.toString();
        TreeModel treeModel = jTree.getModel();
        if (treeModel instanceof TreeModelEx) {
            string = ((TreeModelEx)treeModel).getLabel(object);
            icon = ((TreeModelEx)treeModel).getIcon(object);
        }
        if (icon == null) {
            icon = bl3 ? this.m_Leaf : (bl2 ? this.m_Expanded : this.m_Collapsed);
        }
        this.setText(string);
        this.setIcon(icon);
        this.setFont(jTree.getFont());
        return this;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.doPopup(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.doPopup(mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.doPopup(mouseEvent);
        } else if (mouseEvent.getClickCount() == 2) {
            this.doDoubleClick(mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected void doPopup(MouseEvent mouseEvent) {
        TreeModel treeModel = this.m_Tree.getModel();
        if (treeModel instanceof TreeModelEx) {
            Point point = mouseEvent.getPoint();
            int n = this.m_Tree.getRowForLocation(point.x, point.y);
            if (n != -1) {
                TreePath treePath = this.m_Tree.getPathForLocation(point.x, point.y);
                this.m_Tree.setSelectionPath(treePath);
                Object object = treePath.getLastPathComponent();
                JPopupMenu jPopupMenu = ((TreeModelEx)treeModel).getPopupMenu(object);
                if (jPopupMenu != null) {
                    jPopupMenu.show(this.m_Tree, point.x, point.y);
                }
                mouseEvent.consume();
            }
        }
    }

    protected void doDoubleClick(MouseEvent mouseEvent) {
        TreeModel treeModel = this.m_Tree.getModel();
        if (treeModel instanceof TreeModelEx) {
            Point point = mouseEvent.getPoint();
            int n = this.m_Tree.getRowForLocation(point.x, point.y);
            TreePath treePath = this.m_Tree.getPathForLocation(point.x, point.y);
            if (n != -1) {
                Object object = treePath.getLastPathComponent();
                ((TreeModelEx)treeModel).doDoubleClick(object);
                mouseEvent.consume();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        TreeModel treeModel = this.m_Tree.getModel();
        if (treeModel instanceof TreeModelEx && keyEvent.getKeyCode() == 10) {
            TreePath treePath = this.m_Tree.getSelectionPath();
            Object object = treePath.getLastPathComponent();
            ((TreeModelEx)treeModel).doDoubleClick(object);
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    private void loadUI() {
        this.m_Expanded = UIManager.getIcon("Tree.openIcon");
        this.m_Collapsed = UIManager.getIcon("Tree.closedIcon");
        this.m_Leaf = UIManager.getIcon("Tree.leafIcon");
        this.m_TextSelectionColor = Color.white;
        this.m_TextNonSelectionColor = UIManager.getColor("Tree.textForeground");
    }

    private static class TCEditor
    extends JTextField
    implements TreeCellEditor,
    ActionListener {
        private final List<CellEditorListener> m_Listeners = new ArrayList<CellEditorListener>();
        private TreeModelEx m_TreeModel;
        private Object m_Value;

        public TCEditor() {
            super(16);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("actionPerformed");
            this.stopCellEditing();
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            String string = object.toString();
            TreeModel treeModel = jTree.getModel();
            if (treeModel instanceof TreeModelEx) {
                this.m_TreeModel = (TreeModelEx)treeModel;
                string = this.m_TreeModel.getLabel(object);
                this.m_Value = object;
            }
            this.setText(string);
            this.setFont(jTree.getFont());
            return this;
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.m_Listeners.add(cellEditorListener);
        }

        @Override
        public void cancelCellEditing() {
            ChangeEvent changeEvent = new ChangeEvent(this);
            Iterator<CellEditorListener> iterator = this.m_Listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().editingCanceled(changeEvent);
            }
            this.m_Value = null;
        }

        @Override
        public Object getCellEditorValue() {
            return this.getText();
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                return ((MouseEvent)eventObject).getClickCount() == 2;
            }
            return false;
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.m_Listeners.remove(cellEditorListener);
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            ChangeEvent changeEvent = new ChangeEvent(this);
            Iterator<CellEditorListener> iterator = this.m_Listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().editingStopped(changeEvent);
            }
            if (this.m_Value != null) {
                this.m_TreeModel.setLabel(this.m_Value, this.getText());
            }
            this.m_Value = null;
            return true;
        }
    }
}

