/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.tree;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeUtil {
    public static int getRow(TreeModel treeModel, Object object) {
        IndexHolder indexHolder = new IndexHolder(0);
        if (TreeUtil.getRow(treeModel, treeModel.getRoot(), object, indexHolder)) {
            int n = indexHolder.value;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            TreeUtil.buildList(treeModel, treeModel.getRoot(), arrayList);
            assert (n < 0 || arrayList.get(n) == object) : "TreeUtil error (a)";
            assert (n < 0 || TreeUtil.getObject(treeModel, treeModel.getRoot(), new IndexHolder(n)) == object) : "TreeUtil error (b)";
            return n;
        }
        return -1;
    }

    private static boolean getRow(TreeModel treeModel, Object object, Object object2, IndexHolder indexHolder) {
        if (object == object2) {
            return true;
        }
        ++indexHolder.value;
        int n = treeModel.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            Object object3 = treeModel.getChild(object, i);
            if (!TreeUtil.getRow(treeModel, object3, object2, indexHolder)) continue;
            return true;
        }
        return false;
    }

    public static Object getObject(TreeModel treeModel, int n) {
        if (n < 0) {
            return null;
        }
        Object object = TreeUtil.getObject(treeModel, treeModel.getRoot(), new IndexHolder(n));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TreeUtil.buildList(treeModel, treeModel.getRoot(), arrayList);
        assert (object == null || arrayList.get(n) == object) : "TreeUtil error (c)";
        IndexHolder indexHolder = new IndexHolder(0);
        TreeUtil.getRow(treeModel, treeModel.getRoot(), object, indexHolder);
        assert (object == null || indexHolder.value == n) : "TreeUtil error (d)";
        return object;
    }

    private static Object getObject(TreeModel treeModel, Object object, IndexHolder indexHolder) {
        if (indexHolder.value == 0) {
            return object;
        }
        --indexHolder.value;
        int n = treeModel.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = treeModel.getChild(object, i);
            Object object3 = TreeUtil.getObject(treeModel, object2, indexHolder);
            if (object3 == null) continue;
            return object3;
        }
        return null;
    }

    public static Object getLastObject(TreeModel treeModel) {
        return TreeUtil.getLastObject(treeModel, treeModel.getRoot());
    }

    public static void expandTree(JTree jTree) {
        int n = jTree.getRowCount();
        for (int i = n - 1; i >= 0; --i) {
            jTree.expandRow(i);
        }
    }

    public static void expandAll(JTree jTree) {
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            jTree.expandRow(i);
        }
    }

    public static void preventRootCollapse(JTree jTree) {
        jTree.addTreeWillExpandListener(new PreventRootCollapse());
    }

    private static Object getLastObject(TreeModel treeModel, Object object) {
        int n = treeModel.getChildCount(object);
        if (n == 0) {
            return object;
        }
        return TreeUtil.getLastObject(treeModel, treeModel.getChild(object, n - 1));
    }

    private static void buildList(TreeModel treeModel, Object object, List<Object> list) {
        list.add(object);
        int n = treeModel.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            TreeUtil.buildList(treeModel, treeModel.getChild(object, i), list);
        }
    }

    private static class IndexHolder {
        public int value;

        public IndexHolder(int n) {
            this.value = n;
        }
    }

    private static class PreventRootCollapse
    implements TreeWillExpandListener {
        private PreventRootCollapse() {
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            TreePath treePath = treeExpansionEvent.getPath();
            if (treePath.getPathCount() == 1) {
                throw new ExpandVetoException(treeExpansionEvent);
            }
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        }
    }
}

