/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.wizard;

import com.elixirtech.arch.IUINavigator;
import com.elixirtech.arch.UINavigatorPath;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardContainer;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.ui.wizard.WizardDialog;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Wizard
implements IWizard {
    protected IWizardContainer m_Container;
    protected final List<IWizardPage> m_Pages = new ArrayList<IWizardPage>();
    protected String m_WindowTitle;
    private boolean m_ReadOnly;
    protected boolean m_Finished;
    protected Map<String, String> m_StringAttributes = new HashMap<String, String>();
    protected Map<String, Object> m_ObjectAttributes = new HashMap<String, Object>();

    public Wizard() {
    }

    public Wizard(String string) {
        this.m_WindowTitle = string;
    }

    @Override
    public void showUINavigator(UINavigatorPath uINavigatorPath) {
        IWizardContainer iWizardContainer = this.getContainer();
        if (uINavigatorPath.hasNext() && iWizardContainer instanceof WizardDialog) {
            String string = uINavigatorPath.next();
            if (string.startsWith("[")) {
                WizardDialog wizardDialog = (WizardDialog)iWizardContainer;
                if ("[Previous]".equals(string)) {
                    wizardDialog.previous();
                }
                if ("[Next]".equals(string)) {
                    wizardDialog.next();
                }
                if ("[Finish]".equals(string)) {
                    wizardDialog.finish();
                }
                if ("[Cancel]".equals(string)) {
                    wizardDialog.cancel();
                }
            } else {
                IWizardPage iWizardPage = this.getPage(string);
                if (iWizardPage != null) {
                    iWizardContainer.showPage(iWizardPage);
                    if (iWizardPage instanceof IUINavigator) {
                        ((IUINavigator)((Object)iWizardPage)).showUINavigator(uINavigatorPath);
                    }
                }
            }
        }
    }

    @Override
    public boolean canFinish() {
        if (this.isReadOnly()) {
            return false;
        }
        for (IWizardPage iWizardPage : this.m_Pages) {
            if (iWizardPage.isPageComplete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        for (IWizardPage iWizardPage : this.m_Pages) {
            iWizardPage.dispose();
        }
    }

    @Override
    public IWizardContainer getContainer() {
        return this.m_Container;
    }

    @Override
    public boolean canFlipToNextPage(IWizardPage iWizardPage) {
        return iWizardPage.canFlipToNextPage();
    }

    @Override
    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        return iWizardPage.getNextPage();
    }

    public boolean hasPage(String string) {
        if (string == null) {
            return false;
        }
        for (IWizardPage iWizardPage : this.m_Pages) {
            if (!string.equals(iWizardPage.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public IWizardPage getPage(String string) {
        if (string == null) {
            return null;
        }
        for (IWizardPage iWizardPage : this.m_Pages) {
            if (!string.equals(iWizardPage.getName())) continue;
            return iWizardPage;
        }
        return null;
    }

    @Override
    public int getPageCount() {
        return this.m_Pages.size();
    }

    @Override
    public IWizardPage[] getPages() {
        IWizardPage[] iWizardPageArray = new IWizardPage[this.m_Pages.size()];
        this.m_Pages.toArray(iWizardPageArray);
        return iWizardPageArray;
    }

    @Override
    public IWizardPage getPreviousPage(IWizardPage iWizardPage) {
        return iWizardPage.getPreviousPage();
    }

    @Override
    public IWizardPage getStartingPage() {
        return this.m_Pages.get(0);
    }

    @Override
    public String getWindowTitle() {
        if (this.isReadOnly()) {
            return this.m_WindowTitle + " (" + Bundle.ARCH.getString("Wizard.READ_ONLY") + ")";
        }
        return this.m_WindowTitle;
    }

    public void setWindowTitle(String string) {
        this.m_WindowTitle = string;
    }

    @Override
    public boolean isHelpAvailable() {
        return false;
    }

    @Override
    public boolean needsPreviousAndNextButtons() {
        return true;
    }

    @Override
    public boolean needsProgressMonitor() {
        return false;
    }

    @Override
    public boolean performCancel() {
        this.m_Finished = false;
        return true;
    }

    @Override
    public boolean performFinish() {
        this.m_Finished = true;
        return true;
    }

    @Override
    public void setContainer(IWizardContainer iWizardContainer) {
        this.m_Container = iWizardContainer;
    }

    @Override
    public boolean isFinished() {
        return this.m_Finished;
    }

    @Override
    public boolean isStandardSize() {
        return true;
    }

    @Override
    public Dimension getSize() {
        return null;
    }

    @Override
    public void setReadOnly(boolean bl) {
        this.m_ReadOnly = bl;
    }

    @Override
    public boolean isReadOnly() {
        return this.m_ReadOnly;
    }

    @Override
    public void putString(String string, String string2) {
        this.m_StringAttributes.put(string, string2);
    }

    @Override
    public String getString(String string) {
        return this.m_StringAttributes.get(string);
    }

    @Override
    public void putObject(String string, Object object) {
        this.m_ObjectAttributes.put(string, object);
    }

    @Override
    public Object getObject(String string) {
        return this.m_ObjectAttributes.get(string);
    }
}

