/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.wizard;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardContainer;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.ui.wizard.WizardMessageBar;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public class WizardDialog
extends JDialog
implements IWizardContainer {
    public static Dimension STANDARD_SIZE = new Dimension(520, 440);
    private final JFrame m_Parent;
    private final IWizard m_Wizard;
    private JButton m_Previous;
    private JButton m_Next;
    private JButton m_Finish;
    private JButton m_Cancel;
    private IWizardPage m_CurrentPage;
    private WizardMessageBar m_Message;
    public static final Font TITLE_FONT = new Font("SansSerif", 1, 16);
    public static final Font MESSAGE_FONT = new Font("SansSerif", 0, 14);
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(WizardDialog.class);

    public WizardDialog(JFrame jFrame, IWizard iWizard) {
        super((Frame)jFrame, true);
        this.setTitle("Wizard");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WL());
        this.m_Parent = jFrame;
        this.m_Wizard = iWizard;
        this.m_Wizard.setContainer(this);
        this.buildUI();
        this.showPage(this.m_Wizard.getStartingPage());
    }

    public IWizard getWizard() {
        return this.m_Wizard;
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.m_Wizard.isStandardSize()) {
            this.setSize(STANDARD_SIZE);
        } else {
            Dimension dimension = this.m_Wizard.getSize();
            if (dimension == null) {
                this.pack();
            } else {
                this.setSize(dimension);
            }
        }
        this.setLocationRelativeTo(this.m_Parent);
        super.setVisible(true);
    }

    @Override
    public IWizardPage getCurrentPage() {
        return this.m_CurrentPage;
    }

    @Override
    public void showPage(IWizardPage iWizardPage) {
        if (this.m_CurrentPage != null) {
            this.m_CurrentPage.setVisible(false);
            this.getContentPane().remove(this.m_CurrentPage.getComponent());
        }
        this.m_CurrentPage = iWizardPage;
        Component component = this.m_CurrentPage.getComponent();
        if (component != null) {
            this.getContentPane().add(component, "Center");
            this.m_CurrentPage.setVisible(true);
            this.validate();
        }
        this.updateButtons();
        this.updateMessage();
        this.updateTitleBar();
        this.repaint();
    }

    @Override
    public void updateButtons() {
        IWizardPage iWizardPage = this.getCurrentPage();
        if (this.m_Previous != null) {
            this.m_Previous.setEnabled(iWizardPage.getPreviousPage() != null);
        }
        if (this.m_Next != null) {
            this.m_Next.setEnabled(this.m_Wizard.canFlipToNextPage(iWizardPage));
        }
        this.m_Finish.setEnabled(this.m_Wizard.canFinish());
    }

    @Override
    public void updateMessage() {
        IWizardPage iWizardPage = this.getCurrentPage();
        this.m_Message.setTitle(iWizardPage.getTitle());
        this.m_Message.setIcon(iWizardPage.getIcon());
        this.m_Message.setMessage(iWizardPage.getMessage());
        this.m_Message.setError(iWizardPage.getError());
        this.m_Message.repaint();
    }

    @Override
    public void updateTitleBar() {
        this.setTitle(this.m_Wizard.getWindowTitle());
    }

    protected void buildUI() {
        AbstractAction abstractAction;
        AbstractAction abstractAction2;
        JComponent jComponent = (JComponent)this.getContentPane();
        JRootPane jRootPane = this.getRootPane();
        ActionMap actionMap = jRootPane.getActionMap();
        InputMap inputMap = jRootPane.getInputMap(1);
        this.m_Message = new WizardMessageBar();
        jComponent.add((Component)this.m_Message, "North");
        JPanel jPanel = new JPanel(new FlowLayout(2));
        if (this.m_Wizard.needsPreviousAndNextButtons()) {
            abstractAction2 = new PreviousAction();
            this.m_Previous = new JButton(abstractAction2);
            inputMap.put(KeyStroke.getKeyStroke(37, 512), "previous");
            actionMap.put("previous", abstractAction2);
            jPanel.add(this.m_Previous);
            abstractAction = new NextAction();
            this.m_Next = new JButton(abstractAction);
            inputMap.put(KeyStroke.getKeyStroke(39, 512), "next");
            actionMap.put("next", abstractAction);
            jPanel.add(this.m_Next);
        }
        abstractAction2 = new FinishAction();
        this.m_Finish = new JButton(abstractAction2);
        inputMap.put(KeyStroke.getKeyStroke(10, 512), "finish");
        actionMap.put("finish", abstractAction2);
        jPanel.add(this.m_Finish);
        abstractAction = new CancelAction();
        this.m_Cancel = new JButton(abstractAction);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        actionMap.put("cancel", abstractAction);
        jPanel.add(this.m_Cancel);
        jComponent.add((Component)jPanel, "South");
    }

    public void previous() {
        if (this.m_Previous.isEnabled()) {
            try {
                this.showPage(this.getCurrentPage().getPreviousPage());
            }
            catch (Exception exception) {
                m_Log.error((Object)("previous error: " + String.valueOf(exception)), (Throwable)exception);
            }
        }
    }

    public void next() {
        if (this.m_Next.isEnabled()) {
            try {
                IWizardPage iWizardPage = this.getCurrentPage();
                IWizardPage iWizardPage2 = this.m_Wizard.getNextPage(iWizardPage);
                if (iWizardPage2 != null && iWizardPage != iWizardPage2) {
                    iWizardPage2.setPreviousPage(iWizardPage);
                    this.showPage(iWizardPage2);
                }
            }
            catch (Exception exception) {
                m_Log.error((Object)("next error: " + String.valueOf(exception)), (Throwable)exception);
            }
        }
    }

    @Override
    public void finish() {
        if (this.m_Finish.isEnabled() && this.m_Wizard.performFinish()) {
            this.dispose();
        }
    }

    public void cancel() {
        if (this.m_Cancel.isEnabled() && this.m_Wizard.performCancel()) {
            this.dispose();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_Wizard.dispose();
    }

    protected static String getString(String string) {
        return Bundle.BASE.getString(string);
    }

    private class WL
    extends WindowAdapter {
        private WL() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            WizardDialog.this.cancel();
        }
    }

    private class PreviousAction
    extends AbstractAction {
        public PreviousAction() {
            super(WizardDialog.getString("Previous"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WizardDialog.this.previous();
        }
    }

    private class NextAction
    extends AbstractAction {
        public NextAction() {
            super(WizardDialog.getString("Next"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WizardDialog.this.next();
        }
    }

    private class FinishAction
    extends AbstractAction {
        public FinishAction() {
            super(WizardDialog.getString("Finish"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WizardDialog.this.finish();
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(WizardDialog.getString("Cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WizardDialog.this.cancel();
        }
    }
}

