/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.wizard;

import com.elixirtech.ui.wizard.WizardDialog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.Icon;
import javax.swing.JComponent;

public class WizardMessageBar
extends JComponent {
    private String m_Title;
    private String m_Message;
    private String m_Error;
    private Icon m_Icon;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 80);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        int n = dimension.width;
        if (this.m_Icon != null) {
            int n2 = dimension.width - this.m_Icon.getIconWidth();
            int n3 = (dimension.height - this.m_Icon.getIconHeight()) / 2;
            this.m_Icon.paintIcon(this, graphics, n2, n3);
            n -= this.m_Icon.getIconWidth();
        }
        Shape shape = graphics.getClip();
        graphics.clipRect(0, 0, n - 5, dimension.height);
        graphics.setColor(Color.BLACK);
        if (this.m_Title != null) {
            graphics.setFont(WizardDialog.TITLE_FONT);
            graphics.drawString(this.m_Title, 10, 30);
        }
        if (this.m_Message != null) {
            graphics.setFont(WizardDialog.MESSAGE_FONT);
            graphics.drawString(this.m_Message, 20, 50);
        }
        if (this.m_Error != null && this.m_Error.length() > 0) {
            graphics.setColor(Color.red);
            graphics.fillOval(20, 60, 8, 8);
            graphics.setColor(Color.black);
            graphics.drawOval(20, 60, 8, 8);
            graphics.setFont(WizardDialog.MESSAGE_FONT);
            graphics.drawString(this.m_Error, 33, 70);
        }
        graphics.setClip(shape);
    }

    public Icon getIcon() {
        return this.m_Icon;
    }

    public void setIcon(Icon icon) {
        this.m_Icon = icon;
    }

    public String getMessage() {
        return this.m_Message;
    }

    public void setMessage(String string) {
        this.m_Message = string;
    }

    public String getError() {
        return this.m_Error;
    }

    public void setError(String string) {
        this.m_Error = string;
    }

    public String getTitle() {
        return this.m_Title;
    }

    public void setTitle(String string) {
        this.m_Title = string;
    }
}

