/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.wizard;

import com.elixirtech.ui.ImageManager;
import com.elixirtech.ui.SwingUtils;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardPage;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JPanel;

public class WizardPage
implements IWizardPage {
    private static final String BASE = "com/elixirtech/ui/wizard/";
    public static final Icon ICON = ImageManager.getIconResource("com/elixirtech/ui/wizard/default-image.png");
    protected JPanel m_Component;
    protected Icon m_Icon;
    protected String m_Title;
    protected String m_Message;
    protected String m_Error;
    protected final String m_PageName;
    protected IWizard m_Wizard;
    protected IWizardPage m_PreviousPage;
    protected String m_NextPage;
    private boolean m_ReadOnly;

    public WizardPage(String string, String string2) {
        this.m_PageName = string;
        this.m_NextPage = string2;
        this.m_Component = new JPanel();
        this.m_ReadOnly = false;
        this.m_Icon = ICON;
    }

    @Override
    public void dispose() {
        this.m_Component = null;
    }

    @Override
    public Component getComponent() {
        this.updateReadOnlyStatus();
        return this.m_Component;
    }

    private void updateReadOnlyStatus() {
        if (this.m_Wizard.isReadOnly() != this.m_ReadOnly) {
            this.setReadOnly(this.m_Wizard.isReadOnly());
            this.m_ReadOnly = this.m_Wizard.isReadOnly();
        }
    }

    protected void setReadOnly(boolean bl) {
        SwingUtils.setComponentEnabled(this.m_Component, !bl, this.getAlwaysEnabledComponents());
    }

    protected Set<Component> getAlwaysEnabledComponents() {
        return new HashSet<Component>();
    }

    @Override
    public Icon getIcon() {
        return this.m_Icon;
    }

    @Override
    public String getMessage() {
        return this.m_Message;
    }

    @Override
    public String getError() {
        return this.m_Error;
    }

    @Override
    public String getTitle() {
        return this.m_Title;
    }

    @Override
    public void performHelp() {
    }

    @Override
    public void setIcon(Icon icon) {
        this.m_Icon = icon;
    }

    @Override
    public void setTitle(String string) {
        this.m_Title = string;
    }

    @Override
    public void setMessage(String string) {
        this.m_Message = string != null ? string.trim() : null;
    }

    @Override
    public void setError(String string) {
        this.m_Error = string != null ? string.trim() : null;
    }

    @Override
    public void setVisible(boolean bl) {
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.m_NextPage != null;
    }

    @Override
    public String getName() {
        return this.m_PageName;
    }

    @Override
    public IWizardPage getNextPage() {
        return this.m_Wizard.getPage(this.m_NextPage);
    }

    public void setNextPage(String string) {
        this.m_NextPage = string;
    }

    public String getNextPageName() {
        return this.m_NextPage;
    }

    @Override
    public IWizardPage getPreviousPage() {
        return this.m_PreviousPage;
    }

    @Override
    public IWizard getWizard() {
        return this.m_Wizard;
    }

    @Override
    public boolean isPageComplete() {
        return false;
    }

    @Override
    public void setPreviousPage(IWizardPage iWizardPage) {
        this.m_PreviousPage = iWizardPage;
    }

    @Override
    public void setWizard(IWizard iWizard) {
        this.m_Wizard = iWizard;
    }
}

