/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.util;

public class CharUtil {
    public static boolean isCJK(char c) {
        return c >= '\u4e00' && c <= '\u9fff' || c >= '\u3400' && c <= '\u4dff' || c >= '\uf900' && c <= '\ufaff' || c >= '\u3040' && c <= '\u309f' || c >= '\u30a0' && c <= '\u30ff';
    }

    public static boolean isHebrew(char c) {
        return c >= '\u0590' && c <= '\u05ff';
    }

    public static boolean isArabic(char c) {
        return c >= '\u0600' && c <= '\u06ff';
    }

    public static boolean isSyriac(char c) {
        return c >= '\u0700' && c <= '\u074f';
    }

    public static boolean isJoined(char c) {
        return c >= '\u0590' && c <= '\u074f';
    }

    public static String decodeSlashU(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf("\\u");
        if (n < 0) {
            return string;
        }
        int n2 = 0;
        int n3 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        while (n >= 0 && n + 6 <= n3) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(CharUtil.unicodeFrom(string, n + 2));
            n2 = n + 6;
            n = string.indexOf("\\u", n2);
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    private static char unicodeFrom(String string, int n) {
        int n2 = 0;
        block5: for (int i = 0; i < 4; ++i) {
            char c = string.charAt(n + i);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    n2 = (n2 << 4) + c - 48;
                    continue block5;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    n2 = (n2 << 4) + 10 + c - 97;
                    continue block5;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    n2 = (n2 << 4) + 10 + c - 65;
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Malformed \\uXXXX encoding.");
                }
            }
        }
        return (char)n2;
    }
}

