/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.util;

import com.elixirtech.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class EmailAddressUtil {
    private static final Pattern EMAIL_REGEX = Pattern.compile("^[\\w-]+(\\.[\\w-]+)*@([a-z0-9-]+(\\.[a-z0-9-]+)*?\\.[a-z]{2,6}|(\\d{1,3}\\.){3}\\d{1,3})(:\\d{4})?$");

    public static List<String> splitAddressList(String string) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (StringUtil.isEmpty(string)) {
            return arrayList;
        }
        for (String string2 : stringArray = string.split(",|;")) {
            if (!StringUtil.notEmpty(string2.trim())) continue;
            arrayList.add(string2.trim());
        }
        return arrayList;
    }

    public static boolean validateEmailAddress(String string) {
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        return EMAIL_REGEX.matcher(string.trim()).matches();
    }

    public static boolean validateEmailAddressList(String string) {
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        return EmailAddressUtil.findInvalidEmailAddress(string) == null;
    }

    public static String findInvalidEmailAddress(String string) {
        List<String> list = EmailAddressUtil.splitAddressList(string);
        for (String string2 : list) {
            if (EmailAddressUtil.validateEmailAddress(string2)) continue;
            return string2;
        }
        return null;
    }
}

