/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.util;

import com.elixirtech.arch.MimeInfo;
import com.elixirtech.arch.MimeType;
import com.elixirtech.util.LineVisitor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public class FileUtil {
    private static final int BUFFSZ = 8192;

    public static File getFile(String string) {
        String string2 = FileUtil.fixPath(string);
        string2 = FileUtil.fixSlashes(string2);
        return new File(string2);
    }

    public static String asURL(File file) {
        return "file:" + FileUtil.slashify(file.getAbsolutePath(), file.isDirectory());
    }

    public static String getFilename(String string, String string2) {
        if (string.indexOf(46) < 0) {
            return string + "." + MimeInfo.extension((MimeType)new MimeType(string2));
        }
        return string;
    }

    public static String getNameWithoutExtension(String string) {
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(92);
        int n3 = string.lastIndexOf(46);
        if (n3 > 0 && n3 > n && n3 > n2) {
            return string.substring(0, n3);
        }
        return string;
    }

    public static String getNameWithoutExtension(String string, String string2) {
        if (string.endsWith(string2)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static File getTempFile(String string) {
        File file = new File(System.getProperty("java.io.tmpdir"));
        return new File(file, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visit(String string, LineVisitor lineVisitor) throws IOException {
        try (BufferedReader bufferedReader = null;){
            String string2;
            bufferedReader = new BufferedReader(new FileReader(string));
            int n = 1;
            while ((string2 = bufferedReader.readLine()) != null) {
                lineVisitor.acceptLine(n++, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(String string, String string2) throws IOException {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            fileOutputStream = new FileOutputStream(string2);
            long l = FileUtil.copyStream(fileInputStream, fileOutputStream);
            return l;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream inputStream, String string) throws IOException {
        try (FileOutputStream fileOutputStream = null;){
            fileOutputStream = new FileOutputStream(string);
            long l = FileUtil.copyStream(inputStream, fileOutputStream);
            return l;
        }
    }

    public static String getExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return "";
    }

    public static String setExtension(String string, String string2) {
        String string3 = FileUtil.getNameWithoutExtension(string);
        if (string2.startsWith(".")) {
            return string3 + string2;
        }
        if (string2.length() > 0) {
            return string3 + "." + string2;
        }
        return string3;
    }

    public static long copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        long l = 0L;
        byte[] byArray = new byte[8192];
        int n;
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static void copyStream(Reader reader, Writer writer, boolean bl) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(writer));
        while (true) {
            String string;
            if ((string = bufferedReader.readLine()) == null) {
                printWriter.flush();
                return;
            }
            if (bl) {
                string = string.trim();
            }
            printWriter.println(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String load(File file) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        try (FileInputStream fileInputStream = null;){
            String string;
            fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            while ((string = bufferedReader.readLine()) != null) {
                printWriter.println(string);
            }
        }
        return stringWriter.toString();
    }

    public static byte[] loadBytes(File file) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(file);
            FileUtil.copyStream(fileInputStream, byteArrayOutputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] loadBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtil.copyStream(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean deleteDir(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = FileUtil.deleteDir(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    private static String fixSlashes(String string) {
        if (string == null) {
            return null;
        }
        if (File.separatorChar == '\\') {
            return string.replace('/', '\\');
        }
        if (File.separatorChar == '/') {
            return string.replace('\\', '/');
        }
        return string;
    }

    private static String fixPath(String string) {
        String string2;
        if (string != null && string.startsWith(".") && (string2 = System.getProperty("elixir.home")) != null) {
            return string2 + string.substring(1);
        }
        return string;
    }

    private static String slashify(String string, boolean bl) {
        Object object = string;
        if (File.separatorChar != '/') {
            object = ((String)object).replace(File.separatorChar, '/');
        }
        if (!((String)object).startsWith("/")) {
            object = "/" + (String)object;
        }
        if (!((String)object).endsWith("/") && bl) {
            object = (String)object + "/";
        }
        return object;
    }
}

