/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;

public class Measurements {
    public static long deepCount(Object object) {
        IdentityHashMap<Object, Object> identityHashMap = new IdentityHashMap<Object, Object>();
        return Measurements.deepCountOf(object, identityHashMap, 0);
    }

    private static long deepCountOf(Object object, Map<Object, Object> map, int n) {
        long l = 0L;
        if (object == null) {
            return 0L;
        }
        if (map.containsKey(object)) {
            return 0L;
        }
        map.put(object, null);
        ++l;
        if (object instanceof Object[]) {
            for (Object object2 : (Object[])object) {
                l += Measurements.deepCountOf(object2, map, n + 1);
            }
        } else {
            Field[] fieldArray;
            for (Field field : fieldArray = object.getClass().getDeclaredFields()) {
                Object object3;
                field.setAccessible(true);
                try {
                    object3 = field.get(object);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                if (!Measurements.isComputable(field)) continue;
                l += Measurements.deepCountOf(object3, map, n + 1);
            }
        }
        return l;
    }

    private static boolean isAPrimitiveType(Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            return true;
        }
        if (clazz == Character.TYPE) {
            return true;
        }
        if (clazz == Byte.TYPE) {
            return true;
        }
        if (clazz == Short.TYPE) {
            return true;
        }
        if (clazz == Integer.TYPE) {
            return true;
        }
        if (clazz == Long.TYPE) {
            return true;
        }
        if (clazz == Float.TYPE) {
            return true;
        }
        return clazz == Double.TYPE;
    }

    private static boolean isComputable(Field field) {
        if (Measurements.isAPrimitiveType(field.getType())) {
            return false;
        }
        int n = field.getModifiers();
        return !Modifier.isStatic(n);
    }
}

