/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.util;

public final class StringStepper {
    private char[] m_String;
    private int m_Index;

    public StringStepper(String string) {
        this.m_String = string.toCharArray();
    }

    public char getChar() {
        if (this.m_Index >= this.m_String.length) {
            return '\u0000';
        }
        return this.m_String[this.m_Index];
    }

    public boolean atEnd() {
        return this.m_Index >= this.m_String.length;
    }

    public void advance() {
        ++this.m_Index;
    }

    public void advance(int n) {
        this.m_Index += n;
        if (this.m_Index > this.m_String.length) {
            this.m_Index = this.m_String.length;
        }
    }

    public String getString() {
        return new String(this.m_String);
    }

    public String substring(int n, int n2) {
        return new String(this.m_String, n, n2 - n);
    }

    public char charAt(int n) {
        return this.m_String[n];
    }

    public int getIndex() {
        return this.m_Index;
    }

    public void eatWhite() {
        char c = this.getChar();
        while (c == '\r' || c == '\n' || c == ' ' || c == '\t') {
            this.advance();
            c = this.getChar();
        }
    }

    public String upTo(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        char c2 = this.getChar();
        while (c2 != c && c2 != '\u0000') {
            stringBuffer.append(c2);
            this.advance();
            c2 = this.getChar();
        }
        return stringBuffer.toString();
    }

    public void skipTo(char c) {
        char c2 = this.getChar();
        while (c2 != c && c2 != '\u0000') {
            this.advance();
            c2 = this.getChar();
        }
    }

    public String remainder() {
        return new String(this.m_String, this.m_Index, this.m_String.length - this.m_Index);
    }
}

