/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.util;

import com.elixirtech.util.Pair;
import com.elixirtech.util.StringUtil;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;

public final class TimeStampParser {
    public static final String INPUT_FORMAT_1 = "HH:mm:ss";
    public static final String INPUT_FORMAT_2 = "HH:mm";
    public static final String INPUT_FORMAT_3 = "hh:mm:ss a";
    public static final String INPUT_FORMAT_4 = "hh:mm a";
    public static final String INPUT_FORMAT_5 = "hh a";
    public static final String INPUT_FORMAT_6 = "a hh:mm:ss";
    public static final String INPUT_FORMAT_7 = "a hh:mm";
    public static final String INPUT_FORMAT_8 = "a hh";
    private static List<Locale> m_CommonLocales = new ArrayList<Locale>();

    public static Calendar parseTime(String string) throws ParseException {
        if (StringUtil.isEmpty(string)) {
            throw new ParseException("Time string is empty.", 0);
        }
        Locale locale = TimeStampParser.guessInputLocale(string);
        return TimeStampParser.parseTime(string, locale);
    }

    public static Calendar parseTime(String string, Locale locale) throws ParseException {
        if (StringUtil.isEmpty(string)) {
            throw new ParseException("Time string is empty.", 0);
        }
        if (locale == null) {
            locale = TimeStampParser.guessInputLocale(string);
        }
        String string2 = TimeStampParser.normalizeString(string, locale);
        String string3 = TimeStampParser.getInputFormat(string2, locale);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3, locale);
        Date date = simpleDateFormat.parse(string2);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return gregorianCalendar;
    }

    public static Locale guessInputLocale(String string) {
        if (StringUtil.isEmpty(string)) {
            throw new IllegalArgumentException("Time string is empty.");
        }
        for (Locale locale : m_CommonLocales) {
            String[] stringArray;
            String[] stringArray2 = new DateFormatSymbols(locale).getAmPmStrings();
            for (String string2 : stringArray = new String[]{stringArray2[0].toLowerCase(Locale.getDefault()), stringArray2[0].toUpperCase(Locale.getDefault()), stringArray2[1].toLowerCase(Locale.getDefault()), stringArray2[1].toUpperCase(Locale.getDefault())}) {
                if (string.indexOf(string2) < 0) continue;
                return locale;
            }
        }
        return Locale.getDefault();
    }

    public static Pair<Integer, Integer> getAmPmIndex(String string, Locale locale) {
        if (StringUtil.isEmpty(string)) {
            throw new IllegalArgumentException("Time string is empty.");
        }
        String[] stringArray = new String[4];
        String[] stringArray2 = new DateFormatSymbols(locale).getAmPmStrings();
        stringArray[0] = stringArray2[0].toLowerCase(Locale.getDefault());
        stringArray[1] = stringArray2[1].toLowerCase(Locale.getDefault());
        stringArray[2] = stringArray2[0].toUpperCase(Locale.getDefault());
        stringArray[3] = stringArray2[1].toUpperCase(Locale.getDefault());
        for (String string2 : stringArray) {
            int n = string.indexOf(string2);
            if (n < 0) continue;
            return new Pair<Integer, Integer>(n, n + string2.length() - 1);
        }
        return null;
    }

    public static boolean endWithAmPm(String string, Locale locale) {
        Pair<Integer, Integer> pair = TimeStampParser.getAmPmIndex(string, locale);
        if (pair == null) {
            return false;
        }
        return (Integer)pair.second == string.length() - 1;
    }

    public static boolean beginWithAmPm(String string, Locale locale) {
        Pair<Integer, Integer> pair = TimeStampParser.getAmPmIndex(string, locale);
        if (pair == null) {
            return false;
        }
        return (Integer)pair.first == 0;
    }

    public static String normalizeString(String string, Locale locale) {
        if (StringUtil.isEmpty(string)) {
            throw new IllegalArgumentException("Time string is empty.");
        }
        String string2 = string.trim();
        if (StringUtil.isEmpty(string2)) {
            throw new IllegalArgumentException("Time string is empty.");
        }
        Pair<Integer, Integer> pair = TimeStampParser.getAmPmIndex(string2, locale);
        if (pair == null) {
            return string2;
        }
        String string3 = string2.substring((Integer)pair.first, (Integer)pair.second + 1);
        StringBuffer stringBuffer = new StringBuffer(string2);
        int n = (Integer)pair.first - 1;
        int n2 = (Integer)pair.second + 1;
        StringBuffer stringBuffer2 = new StringBuffer();
        if (n >= 0 && string2.charAt(n) != ' ') {
            stringBuffer2.append(' ');
        }
        stringBuffer2.append(string3);
        if (n2 < string2.length() && string2.charAt(n2) != ' ') {
            stringBuffer2.append(' ');
        }
        stringBuffer.replace((Integer)pair.first, (Integer)pair.second + 1, stringBuffer2.toString());
        return stringBuffer.toString().trim();
    }

    public static String getInputFormat(String string, Locale locale) throws ParseException {
        String[] stringArray;
        if (StringUtil.isEmpty(string)) {
            throw new IllegalArgumentException("Input string cannot be empty or null.");
        }
        if (TimeStampParser.endWithAmPm(string, locale)) {
            stringArray = string.split(":");
            if (stringArray.length == 1) {
                return INPUT_FORMAT_5;
            }
            if (stringArray.length == 2) {
                return INPUT_FORMAT_4;
            }
            if (stringArray.length == 3) {
                return INPUT_FORMAT_3;
            }
        }
        if (TimeStampParser.beginWithAmPm(string, locale)) {
            stringArray = string.split(":");
            if (stringArray.length == 1) {
                return INPUT_FORMAT_8;
            }
            if (stringArray.length == 2) {
                return INPUT_FORMAT_7;
            }
            if (stringArray.length == 3) {
                return INPUT_FORMAT_6;
            }
        }
        if ((stringArray = string.split(":")).length == 2) {
            return INPUT_FORMAT_2;
        }
        if (stringArray.length == 3) {
            return INPUT_FORMAT_1;
        }
        throw new ParseException("The given time format is not supported: '" + string + "'.", 0);
    }

    private TimeStampParser() {
    }

    static {
        m_CommonLocales.add(Locale.ENGLISH);
        m_CommonLocales.add(Locale.SIMPLIFIED_CHINESE);
        m_CommonLocales.add(Locale.TRADITIONAL_CHINESE);
        m_CommonLocales.add(Locale.JAPANESE);
        m_CommonLocales.add(Locale.CANADA);
        m_CommonLocales.add(Locale.CANADA_FRENCH);
        m_CommonLocales.add(Locale.FRENCH);
        m_CommonLocales.add(Locale.GERMAN);
        m_CommonLocales.add(Locale.ITALIAN);
        m_CommonLocales.add(Locale.KOREAN);
    }
}

