/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.util;

import com.elixirtech.util.StringStepper;
import com.elixirtech.util.StringUtil;
import java.util.ArrayList;
import java.util.Map;

public class VariableSubstitution {
    private ICallback m_Callback;

    public static String substitute(String string, ICallback iCallback) {
        VariableSubstitution variableSubstitution = new VariableSubstitution(iCallback);
        return variableSubstitution.substitute(string);
    }

    public static String substitute(String string, Map<String, String> map) {
        VariableSubstitution variableSubstitution = new VariableSubstitution(map);
        return variableSubstitution.substitute(string);
    }

    public VariableSubstitution(Map<String, String> map) {
        this(new MapCallback(map));
    }

    public VariableSubstitution(ICallback iCallback) {
        this.m_Callback = iCallback;
    }

    public String substitute(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(36) < 0) {
            return string;
        }
        String[] stringArray = this.findParameters(string);
        if (stringArray.length == 0) {
            return string;
        }
        return this.buildResult(string, stringArray);
    }

    private String getSetting(String string) {
        return this.m_Callback.getValue(string);
    }

    private String[] findParameters(String string) {
        char c;
        StringStepper stringStepper = new StringStepper(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((c = stringStepper.getChar()) != '\u0000') {
            if (c == '\\') {
                stringStepper.advance();
                stringStepper.advance();
                continue;
            }
            if (c == '$') {
                stringStepper.advance();
                char c2 = stringStepper.getChar();
                if (c2 != '{') continue;
                stringStepper.advance();
                int n = stringStepper.getIndex();
                while (stringStepper.getChar() != '}') {
                    stringStepper.advance();
                    if (stringStepper.getChar() != '\\') continue;
                    stringStepper.advance();
                }
                int n2 = stringStepper.getIndex();
                arrayList.add(string.substring(n - 2, n2 + 1));
                continue;
            }
            stringStepper.advance();
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private String buildResult(String string, String[] stringArray) {
        String string2 = string;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i].substring(2, stringArray[i].length() - 1);
            String string4 = this.getSetting(string3);
            if (string4 == null) continue;
            string2 = StringUtil.findAndReplace(string2, stringArray[i], string4);
        }
        return string2;
    }

    public static interface ICallback {
        public String getValue(String var1);
    }

    private static class MapCallback
    implements ICallback {
        private Map<String, String> m_Map;

        public MapCallback(Map<String, String> map) {
            this.m_Map = map;
        }

        @Override
        public String getValue(String string) {
            return this.m_Map.get(string);
        }
    }
}

