/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.v2;

import com.elixirtech.arch.ElxLoggerJ;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMLWriter
extends XMLFilterImpl {
    private static final Attributes EMPTY_ATTS = new AttributesImpl();
    private Hashtable<String, String> m_PrefixTable;
    private Hashtable<String, Boolean> m_ForcedDeclTable;
    private Hashtable<String, String> m_DoneDeclTable;
    private int m_ElementLevel;
    private Writer m_Output;
    private NamespaceSupport m_NsSupport;
    private int m_PrefixCounter;

    public XMLWriter() {
        this.init(null);
    }

    public XMLWriter(Writer writer) {
        this.init(writer);
    }

    public XMLWriter(XMLReader xMLReader) {
        super(xMLReader);
        this.init(null);
    }

    public XMLWriter(XMLReader xMLReader, Writer writer) {
        super(xMLReader);
        this.init(writer);
    }

    private void init(Writer writer) {
        this.setOutput(writer);
        this.m_NsSupport = new NamespaceSupport();
        this.m_PrefixTable = new Hashtable();
        this.m_ForcedDeclTable = new Hashtable();
        this.m_DoneDeclTable = new Hashtable();
    }

    public void reset() {
        this.m_ElementLevel = 0;
        this.m_PrefixCounter = 0;
        this.m_NsSupport.reset();
    }

    public void flush() throws IOException {
        this.m_Output.flush();
    }

    public void setOutput(Writer writer) {
        this.m_Output = writer == null ? new OutputStreamWriter(System.out) : writer;
    }

    public void setPrefix(String string, String string2) {
        this.m_PrefixTable.put(string, string2);
    }

    public String getPrefix(String string) {
        return this.m_PrefixTable.get(string);
    }

    public void forceNSDecl(String string) {
        this.m_ForcedDeclTable.put(string, Boolean.TRUE);
    }

    public void forceNSDecl(String string, String string2) {
        this.setPrefix(string, string2);
        this.forceNSDecl(string);
    }

    @Override
    public void startDocument() throws SAXException {
        this.reset();
        this.write("<?xml version=\"1.0\" standalone=\"yes\"?>\n\n");
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.write('\n');
        super.endDocument();
        try {
            this.flush();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ++this.m_ElementLevel;
        this.m_NsSupport.pushContext();
        this.write('<');
        this.writeName(string, string2, string3, true);
        this.writeAttributes(attributes);
        if (this.m_ElementLevel == 1) {
            this.forceNSDecls();
        }
        this.writeNSDecls();
        this.write('>');
        super.startElement(string, string2, string3, attributes);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.write("</");
        this.writeName(string, string2, string3, true);
        this.write('>');
        if (this.m_ElementLevel == 1) {
            this.write('\n');
        }
        super.endElement(string, string2, string3);
        this.m_NsSupport.popContext();
        --this.m_ElementLevel;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.writeEsc(cArray, n, n2, false);
        super.characters(cArray, n, n2);
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.writeEsc(cArray, n, n2, false);
        super.ignorableWhitespace(cArray, n, n2);
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        this.write("<?");
        this.write(string);
        this.write(' ');
        this.write(string2);
        this.write("?>");
        if (this.m_ElementLevel < 1) {
            this.write('\n');
        }
        super.processingInstruction(string, string2);
    }

    public void emptyElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.m_NsSupport.pushContext();
        this.write('<');
        this.writeName(string, string2, string3, true);
        this.writeAttributes(attributes);
        if (this.m_ElementLevel == 1) {
            this.forceNSDecls();
        }
        this.writeNSDecls();
        this.write("/>");
        super.startElement(string, string2, string3, attributes);
        super.endElement(string, string2, string3);
    }

    public void startElement(String string, String string2) throws SAXException {
        this.startElement(string, string2, "", EMPTY_ATTS);
    }

    public void startElement(String string) throws SAXException {
        this.startElement("", string, "", EMPTY_ATTS);
    }

    public void endElement(String string, String string2) throws SAXException {
        this.endElement(string, string2, "");
    }

    public void endElement(String string) throws SAXException {
        this.endElement("", string, "");
    }

    public void emptyElement(String string, String string2) throws SAXException {
        this.emptyElement(string, string2, "", EMPTY_ATTS);
    }

    public void emptyElement(String string) throws SAXException {
        this.emptyElement("", string, "", EMPTY_ATTS);
    }

    public void dataElement(String string, String string2, String string3, Attributes attributes, String string4) throws SAXException {
        this.startElement(string, string2, string3, attributes);
        this.characters(string4);
        this.endElement(string, string2, string3);
    }

    public void dataElement(String string, String string2, String string3) throws SAXException {
        this.dataElement(string, string2, "", EMPTY_ATTS, string3);
    }

    public void dataElement(String string, String string2) throws SAXException {
        this.dataElement("", string, "", EMPTY_ATTS, string2);
    }

    public void characters(String string) throws SAXException {
        char[] cArray = string.toCharArray();
        this.characters(cArray, 0, cArray.length);
    }

    private void forceNSDecls() {
        Enumeration<String> enumeration = this.m_ForcedDeclTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            this.doPrefix(string, null, true);
        }
    }

    private String doPrefix(String string, String string2, boolean bl) {
        String string3 = this.m_NsSupport.getURI("");
        if ("".equals(string)) {
            if (bl && string3 != null) {
                this.m_NsSupport.declarePrefix("", "");
            }
            return null;
        }
        Object object = bl && string3 != null && string.equals(string3) ? "" : this.m_NsSupport.getPrefix(string);
        if (object != null) {
            return object;
        }
        object = this.m_DoneDeclTable.get(string);
        if (object != null && ((!bl || string3 != null) && "".equals(object) || this.m_NsSupport.getURI((String)object) != null)) {
            object = null;
        }
        if (object == null && (object = this.m_PrefixTable.get(string)) != null && ((!bl || string3 != null) && "".equals(object) || this.m_NsSupport.getURI((String)object) != null)) {
            object = null;
        }
        if (object == null && string2 != null && !"".equals(string2)) {
            int n = string2.indexOf(58);
            if (n == -1) {
                if (bl && string3 == null) {
                    object = "";
                }
            } else {
                object = string2.substring(0, n);
            }
        }
        while (object == null || this.m_NsSupport.getURI((String)object) != null) {
            object = "__NS" + ++this.m_PrefixCounter;
        }
        this.m_NsSupport.declarePrefix((String)object, string);
        this.m_DoneDeclTable.put(string, (String)object);
        return object;
    }

    private void write(char c) throws SAXException {
        try {
            this.m_Output.write(c);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    private void write(String string) throws SAXException {
        try {
            this.m_Output.write(string);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    private void writeAttributes(Attributes attributes) throws SAXException {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            char[] cArray = attributes.getValue(i).toCharArray();
            this.write(' ');
            this.writeName(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), false);
            this.write("=\"");
            this.writeEsc(cArray, 0, cArray.length, true);
            this.write('\"');
        }
    }

    private void writeEsc(char[] cArray, int n, int n2, boolean bl) throws SAXException {
        block6: for (int i = n; i < n + n2; ++i) {
            switch (cArray[i]) {
                case '&': {
                    this.write("&amp;");
                    continue block6;
                }
                case '<': {
                    this.write("&lt;");
                    continue block6;
                }
                case '>': {
                    this.write("&gt;");
                    continue block6;
                }
                case '\"': {
                    if (bl) {
                        this.write("&quot;");
                        continue block6;
                    }
                    this.write('\"');
                    continue block6;
                }
                default: {
                    if (cArray[i] < ' ' && cArray[i] != '\t' && cArray[i] != '\n' && cArray[i] != '\r') {
                        ElxLoggerJ elxLoggerJ = ElxLoggerJ.getLogger(XMLWriter.class);
                        elxLoggerJ.warn((Object)("Control character not allowed in XML: 0x" + Integer.toHexString(cArray[i]) + ". Converting to space"));
                        this.write(' ');
                        continue block6;
                    }
                    if (cArray[i] > '\u007f') {
                        this.write("&#");
                        this.write(Integer.toString(cArray[i]));
                        this.write(';');
                        continue block6;
                    }
                    this.write(cArray[i]);
                }
            }
        }
    }

    private void writeNSDecls() throws SAXException {
        Enumeration<String> enumeration = this.m_NsSupport.getDeclaredPrefixes();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String string2 = this.m_NsSupport.getURI(string);
            if (string2 == null) {
                string2 = "";
            }
            char[] cArray = string2.toCharArray();
            this.write(' ');
            if ("".equals(string)) {
                this.write("xmlns=\"");
            } else {
                this.write("xmlns:");
                this.write(string);
                this.write("=\"");
            }
            this.writeEsc(cArray, 0, cArray.length, true);
            this.write('\"');
        }
    }

    private void writeName(String string, String string2, String string3, boolean bl) throws SAXException {
        String string4 = this.doPrefix(string, string3, bl);
        if (string4 != null && !"".equals(string4)) {
            this.write(string4);
            this.write(':');
        }
        this.write(string2);
    }
}

