/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.v2.swing;

import com.elixirtech.v2.swing.ElxTableModel$;
import com.elixirtech.v2.swing.ElxTableModel$Column$;
import com.elixirtech.v2.swing.ElxTableModel$EditableColumn$;
import java.io.Serializable;
import javax.swing.table.AbstractTableModel;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class ElxTableModel<T>
extends AbstractTableModel {
    private final List<ColModel<T>> columns;
    private final Option<Function2<T, T, Object>> sort;
    private ListBuffer<T> entries;

    public static <T> None$ $lessinit$greater$default$2() {
        return ElxTableModel$.MODULE$.$lessinit$greater$default$2();
    }

    public ElxTableModel(List<ColModel<T>> columns, Option<Function2<T, T, Object>> sort) {
        this.columns = columns;
        this.sort = sort;
        this.entries = new ListBuffer();
    }

    public T entry(int idx) {
        return (T)this.entries.apply(idx);
    }

    public <Q> List<Q> values(Function1<T, Q> fn) {
        return ((ListBuffer)this.entries.map(fn)).toList();
    }

    public Option<T> find(Function1<T, Object> fn) {
        return this.entries.find(fn);
    }

    public int indexWhere(Function1<T, Object> fn) {
        return this.entries.indexWhere(fn);
    }

    public int indexOf(T t) {
        return this.entries.indexOf(t);
    }

    public List<T> getRows() {
        return this.entries.toList();
    }

    public void setRows(Seq<T> rows) {
        this.entries.clear();
        this.entries.$plus$plus$eq(rows);
        this.sort.foreach((Function1)(JProcedure1 & Serializable)fn -> {
            this.entries = (ListBuffer)this.entries.sortWith(fn);
        });
        this.fireTableDataChanged();
    }

    public void addRow(T row) {
        this.entries.$plus$eq(row);
        this.sort.foreach((Function1)(JProcedure1 & Serializable)fn -> {
            this.entries = (ListBuffer)this.entries.sortWith(fn);
        });
        int idx = this.entries.indexOf(row);
        this.fireTableRowsInserted(idx, idx);
    }

    public void setRow(int idx, T row) {
        Option<Function2<T, T, Object>> option = this.sort;
        if (option instanceof Some) {
            Function2 sortfn = (Function2)((Some)option).value();
            this.entries.remove(idx);
            this.fireTableRowsDeleted(idx, idx);
            this.entries.$plus$eq(row);
            this.entries = (ListBuffer)this.entries.sortWith(sortfn);
            int newIdx = this.entries.indexOf(row);
            this.fireTableRowsInserted(newIdx, newIdx);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.entries.update(idx, row);
            this.fireTableRowsUpdated(idx, idx);
            return;
        }
        throw new MatchError(option);
    }

    public T removeRow(int idx) {
        Object t = this.entries.remove(idx);
        this.fireTableRowsDeleted(idx, idx);
        return (T)t;
    }

    public void removeRows(Seq<Object> idxs) {
        ((IterableOnceOps)((SeqOps)idxs.sorted((Ordering)Ordering.Int$.MODULE$)).reverse()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
            this.entries.remove(idx);
            this.fireTableRowsDeleted(idx, idx);
        });
    }

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    @Override
    public Object getValueAt(int rowIdx, int colIdx) {
        Object row = this.entries.apply(rowIdx);
        return ((ColModel)this.columns.apply(colIdx)).get().apply(row);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public String getColumnName(int colIdx) {
        return ((ColModel)this.columns.apply(colIdx)).name();
    }

    @Override
    public boolean isCellEditable(int rowIdx, int colIdx) {
        return ((ColModel)this.columns.apply(colIdx)).put().isDefined();
    }

    @Override
    public void setValueAt(Object value, int rowIdx, int colIdx) {
        Object row = this.entries.apply(rowIdx);
        Option option = ((ColModel)this.columns.apply(colIdx)).put();
        if (option instanceof Some) {
            Function2 set = (Function2)((Some)option).value();
            Object row2 = set.apply(row, value);
            if (row2 == row) {
                this.fireTableRowsUpdated(rowIdx, rowIdx);
                return;
            }
            this.setRow(rowIdx, row2);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public static interface ColModel<T> {
        public String name();

        public Function1<T, Object> get();

        public Option<Function2<T, Object, T>> put();
    }

    public static class Column<T>
    implements ColModel<T>,
    Product,
    Serializable {
        private final String name;
        private final Function1 get;
        private final Option put;

        public static <T> Column<T> apply(String string, Function1<T, Object> function1) {
            return ElxTableModel$Column$.MODULE$.apply(string, function1);
        }

        public static Column<?> fromProduct(Product product) {
            return ElxTableModel$Column$.MODULE$.fromProduct(product);
        }

        public static <T> Column<T> unapply(Column<T> column) {
            return ElxTableModel$Column$.MODULE$.unapply(column);
        }

        public Column(String name, Function1<T, Object> get) {
            this.name = name;
            this.get = get;
            this.put = None$.MODULE$;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Column)) return false;
            Column column = (Column)object;
            String string = this.name();
            String string2 = column.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Function1<T, Object> function1 = this.get();
            Function1<T, Object> function12 = column.get();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!column.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Column;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Column";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "name";
            }
            if (1 == n2) {
                return "get";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Function1<T, Object> get() {
            return this.get;
        }

        @Override
        public Option<Function2<T, Object, T>> put() {
            return this.put;
        }

        public <T> Column<T> copy(String name, Function1<T, Object> get) {
            return new Column<T>(name, get);
        }

        public <T> String copy$default$1() {
            return this.name();
        }

        public <T> Function1<T, Object> copy$default$2() {
            return this.get();
        }

        public String _1() {
            return this.name();
        }

        public Function1<T, Object> _2() {
            return this.get();
        }
    }

    public static class EditableColumn<T>
    implements ColModel<T>,
    Product,
    Serializable {
        private final String name;
        private final Function1 get;
        private final Function2 set;
        private final Option put;

        public static <T> EditableColumn<T> apply(String string, Function1<T, Object> function1, Function2<T, Object, T> function2) {
            return ElxTableModel$EditableColumn$.MODULE$.apply(string, function1, function2);
        }

        public static EditableColumn<?> fromProduct(Product product) {
            return ElxTableModel$EditableColumn$.MODULE$.fromProduct(product);
        }

        public static <T> EditableColumn<T> unapply(EditableColumn<T> editableColumn) {
            return ElxTableModel$EditableColumn$.MODULE$.unapply(editableColumn);
        }

        public EditableColumn(String name, Function1<T, Object> get, Function2<T, Object, T> set) {
            this.name = name;
            this.get = get;
            this.set = set;
            this.put = Some$.MODULE$.apply(set);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof EditableColumn)) return false;
            EditableColumn editableColumn = (EditableColumn)object;
            String string = this.name();
            String string2 = editableColumn.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Function1<T, Object> function1 = this.get();
            Function1<T, Object> function12 = editableColumn.get();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            Function2<T, Object, T> function2 = this.set();
            Function2<T, Object, T> function22 = editableColumn.set();
            if (function2 == null) {
                if (function22 != null) {
                    return false;
                }
            } else if (!function2.equals(function22)) return false;
            if (!editableColumn.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof EditableColumn;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "EditableColumn";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "get";
                }
                case 2: {
                    return "set";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Function1<T, Object> get() {
            return this.get;
        }

        public Function2<T, Object, T> set() {
            return this.set;
        }

        @Override
        public Option<Function2<T, Object, T>> put() {
            return this.put;
        }

        public <T> EditableColumn<T> copy(String name, Function1<T, Object> get, Function2<T, Object, T> set) {
            return new EditableColumn<T>(name, get, set);
        }

        public <T> String copy$default$1() {
            return this.name();
        }

        public <T> Function1<T, Object> copy$default$2() {
            return this.get();
        }

        public <T> Function2<T, Object, T> copy$default$3() {
            return this.set();
        }

        public String _1() {
            return this.name();
        }

        public Function1<T, Object> _2() {
            return this.get();
        }

        public Function2<T, Object, T> _3() {
            return this.set();
        }
    }
}

