/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.v2.swing.repository;

import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.swing.icons.Icon$;
import com.elixirtech.v2.swing.repository.RepositoryTreeModel;
import com.elixirtech.v2.swing.repository.TreeNode;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class FileObjectTreeNode
implements TreeNode {
    private final RepositoryTreeModel model;
    private final Option parent;
    private final FileObject fo;
    private boolean _loaded;
    private ListBuffer<TreeNode> _children;

    public FileObjectTreeNode(RepositoryTreeModel model, Option<TreeNode> parent, FileObject fo) {
        this.model = model;
        this.parent = parent;
        this.fo = fo;
        this._loaded = false;
        this._children = new ListBuffer();
        parent.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.addChild(this));
    }

    @Override
    public RepositoryTreeModel model() {
        return this.model;
    }

    @Override
    public Option<TreeNode> parent() {
        return this.parent;
    }

    @Override
    public FileObject fo() {
        return this.fo;
    }

    public void refresh() {
        this._loaded = false;
        this._children.clear();
    }

    public void ensureChildrenLoaded() {
        FileObjectTreeNode fileObjectTreeNode = this;
        synchronized (fileObjectTreeNode) {
            if (!this._loaded) {
                this._loaded = true;
                this.fo().getChildren().filterNot((Function1 & Serializable)_$2 -> {
                    String string = _$2.getExtension();
                    String string2 = "bak";
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }).foreach((Function1 & Serializable)c -> new FileObjectTreeNode(this.model(), (Option<TreeNode>)Some$.MODULE$.apply((Object)this), (FileObject)c));
                this.sortChildren();
                v0 = BoxedUnit.UNIT;
            } else {
                v0 = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public List<TreeNode> children() {
        this.ensureChildrenLoaded();
        return this._children.toList();
    }

    @Override
    public Option<TreeNode> child(String name) {
        Option optN = this.children().find((Function1 & Serializable)c -> {
            String string = c.name();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        if (optN.isDefined()) {
            return optN;
        }
        this.refresh();
        this.ensureChildrenLoaded();
        Option ret = this.children().find((Function1 & Serializable)c -> {
            String string = c.name();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        if (SwingUtilities.isEventDispatchThread() && ret.isDefined()) {
            this.model().fireStructureChangedEvent(this.model().getTreePath(this));
        }
        return ret;
    }

    @Override
    public Option<TreeNode> child(int idx) {
        this.ensureChildrenLoaded();
        return (Option)this._children.lift().apply((Object)BoxesRunTime.boxToInteger((int)idx));
    }

    @Override
    public int childCount() {
        this.ensureChildrenLoaded();
        return this._children.size();
    }

    @Override
    public void addChild(TreeNode child) {
        this.ensureChildrenLoaded();
        this._children.find((Function1 & Serializable)c -> {
            String string = c.name();
            String string2 = child.name();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).foreach((Function1 & Serializable)c -> (ListBuffer)this._children.$minus$eq(c));
        this._children.$plus$eq((Object)child);
        this.sortChildren();
    }

    @Override
    public void removeChild(TreeNode child) {
        if (this._loaded) {
            this._children.$minus$eq((Object)child);
            return;
        }
    }

    @Override
    public String name() {
        return this.fo().getName();
    }

    @Override
    public String path() {
        return this.fo().getPathString();
    }

    @Override
    public Option<Icon> icon() {
        if (!this.isLeaf()) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)Icon$.MODULE$.unknownFile());
    }

    @Override
    public boolean isLeaf() {
        return this.fo().isData();
    }

    public String toString() {
        return this.name();
    }

    private void sortChildren() {
        this._children = (ListBuffer)this._children.sortWith((Function2 & Serializable)(a, b) -> a.name().compareTo(b.name()) < 0);
    }

    public FileObjectTreeNode copy(FileObjectTreeNode toDir, String name) {
        FileObject fo2 = this.fo().copy(toDir.fo(), name);
        return new FileObjectTreeNode(this.model(), (Option<TreeNode>)Some$.MODULE$.apply((Object)toDir), fo2);
    }

    public FileObjectTreeNode move(FileObjectTreeNode toDir, String name) {
        FileObject fo2 = this.fo().move(toDir.fo(), name);
        this.parent().foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.removeChild(this));
        return new FileObjectTreeNode(this.model(), (Option<TreeNode>)Some$.MODULE$.apply((Object)toDir), fo2);
    }

    public void delete() {
        this.fo().delete();
        this.parent().foreach((Function1)(JProcedure1 & Serializable)_$4 -> _$4.removeChild(this));
    }

    public TreePath getTreePath() {
        return this.model().getTreePath(this);
    }
}

