/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.v2.swing.repository;

import com.elixirtech.v2.swing.repository.INotifier;
import java.awt.Component;
import java.awt.Toolkit;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;

public class PasteNotifier
implements INotifier {
    private final Component parent;
    private ProgressMonitor progressMonitor;
    private boolean cancelled;
    private final String title;

    public PasteNotifier(Component parent) {
        this.parent = parent;
        this.progressMonitor = null;
        this.cancelled = false;
        this.title = "Paste";
    }

    public String title() {
        return this.title;
    }

    @Override
    public void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public void setTotalCount(int total) {
        this.progressMonitor = new ProgressMonitor(this.parent, this.title(), "", 0, total);
    }

    @Override
    public boolean message(int count, String s) {
        if (!this.cancelled) {
            this.progressMonitor.setProgress(count);
            this.progressMonitor.setNote(s);
            this.cancelled = this.progressMonitor.isCanceled();
        }
        return !this.cancelled;
    }

    @Override
    public boolean isOverwriteOk() {
        String msg = "Paste will overwrite. Are you sure?";
        int ret = JOptionPane.showConfirmDialog(this.parent, msg, this.title(), 0);
        return ret == 0;
    }

    @Override
    public void close() {
        this.progressMonitor.close();
    }
}

