/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.v2.swing.repository;

import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import com.elixirtech.v2.swing.repository.RepositoryTreeModel;
import com.elixirtech.v2.swing.repository.RepositoryTreeNode;
import com.elixirtech.v2.swing.repository.TreeNode;
import java.io.Serializable;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.runtime.function.JProcedure1;

public class RepositoryTreeModel
implements TreeModel {
    private final String name;
    private final Repository repository;
    private final ListBuffer<TreeModelListener> listeners;
    private final RepositoryTreeNode root;

    public RepositoryTreeModel(String name, Repository repository) {
        this.name = name;
        this.repository = repository;
        this.listeners = new ListBuffer();
        this.root = new RepositoryTreeNode(this, repository);
    }

    public String name() {
        return this.name;
    }

    public Repository repository() {
        return this.repository;
    }

    public RepositoryTreeNode root() {
        return this.root;
    }

    public Option<JPopupMenu> popupMenu(Object node) {
        return None$.MODULE$;
    }

    public void doDoubleClick(Object node) {
    }

    @Override
    public Object getRoot() {
        return this.root();
    }

    public void refresh() {
        this.root().refresh();
    }

    public TreePath getTreePath(TreeNode node) {
        Option<TreeNode> option = node.parent();
        if (option instanceof Some) {
            TreeNode parent = (TreeNode)((Some)option).value();
            public class Com_elixirtech_v2_swing_repository_RepositoryTreeModel$XTreePath$1
            extends TreePath {
                public Com_elixirtech_v2_swing_repository_RepositoryTreeModel$XTreePath$1(TreePath tp, Object n) {
                    super(tp, n);
                }
            }
            return new Com_elixirtech_v2_swing_repository_RepositoryTreeModel$XTreePath$1(this.getTreePath(parent), node);
        }
        if (None$.MODULE$.equals(option)) {
            return new TreePath(node);
        }
        throw new MatchError(option);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((TreeNode)parent).childCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((TreeNode)node).isLeaf();
    }

    @Override
    public TreeNode getChild(Object parent, int idx) {
        return (TreeNode)this.children((TreeNode)parent).apply(idx);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return this.children((TreeNode)parent).indexOf(child);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.$plus$eq((Object)l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.$minus$eq((Object)l);
    }

    public List<TreeNode> children(TreeNode parent) {
        return parent.children();
    }

    public Option<TreeNode> getTreeNode(FileObject fo) {
        if (fo.getPath().parts().size() == 1) {
            return this.root().child(fo.getName());
        }
        return this.getTreeNode(fo.getParent()).flatMap((Function1 & Serializable)_$1 -> _$1.child(fo.getName()));
    }

    public Option<TreePath> getTreePath(FileObject fo) {
        return this.getTreeNode(fo).map((Function1 & Serializable)node -> this.getTreePath((TreeNode)node));
    }

    public Option<TreeModelEvent> getEvent(TreePath tp) {
        TreeNode n = (TreeNode)tp.getLastPathComponent();
        return n.parent().map((Function1 & Serializable)parent -> {
            TreePath tp = this.getTreePath((TreeNode)parent);
            int[] cidx = new int[]{this.getIndexOfChild(parent, n)};
            Object[] children = new Object[]{n};
            return new TreeModelEvent((Object)this, tp, cidx, children);
        });
    }

    public void fireInsertedEvent(TreePath tp) {
        this.getEvent(tp).foreach((Function1)(JProcedure1 & Serializable)event -> this.fireInsertedEvent((TreeModelEvent)event));
    }

    public void fireChangedEvent(TreePath tp) {
        this.getEvent(tp).foreach((Function1)(JProcedure1 & Serializable)event -> this.fireChangedEvent((TreeModelEvent)event));
    }

    public void fireStructureChangedEvent(TreePath tp) {
        Predef$.MODULE$.require(SwingUtilities.isEventDispatchThread());
        TreeModelEvent ev = new TreeModelEvent((Object)this, tp);
        this.fireStructureChangedEvent(ev);
    }

    public void dispose() {
    }

    public String toString() {
        return "RepositoryTreeModel: " + this.name();
    }

    public void fireInsertedEvent(TreeModelEvent event) {
        Predef$.MODULE$.require(SwingUtilities.isEventDispatchThread());
        this.listeners.foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.treeNodesInserted(event));
    }

    public void fireRemovedEvent(TreeModelEvent event) {
        Predef$.MODULE$.require(SwingUtilities.isEventDispatchThread());
        this.listeners.foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.treeNodesRemoved(event));
    }

    public void fireChangedEvent(TreeModelEvent event) {
        Predef$.MODULE$.require(SwingUtilities.isEventDispatchThread());
        this.listeners.foreach((Function1)(JProcedure1 & Serializable)_$4 -> _$4.treeNodesChanged(event));
    }

    public void fireStructureChangedEvent(TreeModelEvent event) {
        Predef$.MODULE$.require(SwingUtilities.isEventDispatchThread());
        this.listeners.foreach((Function1)(JProcedure1 & Serializable)_$5 -> _$5.treeStructureChanged(event));
    }

    public int normalizeIndex(TreeNode parent, int idx) {
        return idx;
    }
}

