/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.v2.swing.repository;

import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import com.elixirtech.v2.swing.repository.FileObjectTreeNode;
import com.elixirtech.v2.swing.repository.RepositoryTreeModel;
import com.elixirtech.v2.swing.repository.TreeNode;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class RepositoryTreeNode
implements TreeNode {
    private final RepositoryTreeModel model;
    private final Repository repository;
    private ListBuffer<TreeNode> _children;
    private final FileObject fo;
    private final String name;
    private final Option icon;
    private final String path;
    private final Option parent;
    private final boolean isHidden;
    private final boolean isLeaf;

    public RepositoryTreeNode(RepositoryTreeModel model, Repository repository) {
        this.model = model;
        this.repository = repository;
        this._children = new ListBuffer();
        this.refresh();
        this.fo = null;
        this.name = "";
        this.icon = None$.MODULE$;
        this.path = "";
        this.parent = None$.MODULE$;
        this.isHidden = false;
        this.isLeaf = false;
    }

    @Override
    public RepositoryTreeModel model() {
        return this.model;
    }

    public Repository repository() {
        return this.repository;
    }

    @Override
    public Option<TreeNode> child(String name) {
        return this.children().find((Function1 & Serializable)c -> {
            String string = c.name();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public void refresh() {
        this._children.clear();
        this.repository().getFileSystems().foreach((Function1)(JProcedure1 & Serializable)fs -> fs.getRoot().getChildren().foreach((Function1 & Serializable)fo -> new FileObjectTreeNode(this.model(), (Option<TreeNode>)Some$.MODULE$.apply((Object)this), (FileObject)fo)));
        this.sortChildren();
    }

    @Override
    public List<TreeNode> children() {
        return this._children.toList();
    }

    @Override
    public Option<TreeNode> child(int idx) {
        return (Option)this._children.lift().apply((Object)BoxesRunTime.boxToInteger((int)idx));
    }

    @Override
    public int childCount() {
        return this._children.size();
    }

    @Override
    public void addChild(TreeNode child) {
        this._children.$plus$eq((Object)child);
        this.sortChildren();
    }

    @Override
    public void removeChild(TreeNode child) {
        this._children.$minus$eq((Object)child);
    }

    public TreePath getTreePath() {
        return this.model().getTreePath(this);
    }

    @Override
    public FileObject fo() {
        return this.fo;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Option<Icon> icon() {
        return this.icon;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public Option<TreeNode> parent() {
        return this.parent;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    @Override
    public boolean isLeaf() {
        return this.isLeaf;
    }

    private void sortChildren() {
        this._children = (ListBuffer)this._children.sortWith((Function2 & Serializable)(a, b) -> a.name().compareTo(b.name()) < 0);
    }
}

