/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.ISecurity;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.icons.StandardIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.ui.EscapableDialog;
import com.elixirtech.ui.InitialFocusSetter;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IFinishPage;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.util.CodeBlock;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;

public abstract class BasicSecurityPage
extends RelativeLayoutWizardPage
implements IFinishPage {
    public static final String PAGE_NAME = "Security";
    protected JCheckBox m_Encrypted;
    protected JCheckBox m_ReadOnly;
    protected JCheckBox m_HideInternals;
    protected JLabel m_Information;
    protected String m_Password;
    protected boolean m_InternalChange;

    public BasicSecurityPage() {
        super(PAGE_NAME, null);
        I18N.ERD_MAP.injectObject(null, this, "BasicSecurityPage");
        this.setIcon(StandardIcons.PADLOCK);
    }

    @Override
    public Component getComponent() {
        this.setReadOnly(!this.isSecurityPageEditable());
        return this.m_Component;
    }

    private boolean isSecurityPageEditable() {
        return true;
    }

    public boolean isReadOnly() {
        return this.m_ReadOnly.isSelected();
    }

    public boolean isHideInternals() {
        return this.m_HideInternals.isSelected();
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Encrypted = SwingFactory.newCheckBox("encrypt");
        this.m_Encrypted.addItemListener(new CodeBlock((Object)this, "encryptButton"));
        this.m_ReadOnly = SwingFactory.newCheckBox("readonly");
        this.m_ReadOnly.addItemListener(new CodeBlock((Object)this, "readOnlyButton"));
        this.m_HideInternals = SwingFactory.newCheckBox("hide");
        this.m_HideInternals.addItemListener(new CodeBlock((Object)this, "hideInternalsButton"));
        this.m_Information = SwingFactory.newLabel("info");
        this.m_Component.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_Component.add(this.m_Encrypted);
        this.m_Component.add(this.m_ReadOnly);
        this.m_Component.add(this.m_HideInternals);
        this.m_Component.add(this.m_Information);
        I18N.ERD_MAP.injectComponents("BasicSecurityPage.", this.m_Component);
        this.m_Layout.stickTop("readonly");
        this.m_Layout.stickLeft("readonly");
        this.m_Layout.alignBelow("hide", "readonly");
        this.m_Layout.alignBelow("encrypt", "hide");
        this.m_Layout.putBelow("info", "encrypt", 10);
        this.m_Layout.stickLeft("info");
        this.m_Layout.stickRight("info");
        this.m_Layout.stickBottom("info");
    }

    public void init() {
        ISecurity iSecurity = this.getSecurity();
        this.m_InternalChange = true;
        this.m_Encrypted.setSelected(iSecurity.isEncrypted());
        this.m_ReadOnly.setSelected(iSecurity.isReadOnly());
        this.m_HideInternals.setSelected(iSecurity.isHideInternals());
        this.m_InternalChange = false;
        this.m_Password = iSecurity.getPassword();
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    protected abstract ISecurity getSecurity();

    protected abstract void setDirty(boolean var1);

    protected abstract String getModuleName();

    @Override
    public void doFinish() {
        ISecurity iSecurity = this.getSecurity();
        boolean bl = false;
        if (iSecurity.isEncrypted() != this.m_Encrypted.isSelected()) {
            iSecurity.setEncrypted(this.m_Encrypted.isSelected());
            bl = true;
        }
        if (this.m_Encrypted.isSelected()) {
            if (this.changed(iSecurity.getPassword(), this.m_Password)) {
                iSecurity.setPassword(this.m_Password);
                bl = true;
            }
        } else if (iSecurity.getPassword() != null) {
            iSecurity.setPassword(null);
            bl = true;
        }
        if (iSecurity.isReadOnly() != this.m_ReadOnly.isSelected()) {
            iSecurity.setReadOnly(this.m_ReadOnly.isSelected());
            bl = true;
        }
        if (iSecurity.isHideInternals() != this.m_HideInternals.isSelected()) {
            iSecurity.setHideInternals(this.m_HideInternals.isSelected());
            bl = true;
        }
        if (bl) {
            this.setDirty(true);
        }
    }

    private boolean changed(Object object, Object object2) {
        if (object == null) {
            return object2 != null;
        }
        return !object.equals(object2);
    }

    public void encryptButton() {
        if (this.m_InternalChange) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (BasicSecurityPage.this.m_InternalChange) {
                    return;
                }
                BasicSecurityPage.this.m_InternalChange = true;
                if (BasicSecurityPage.this.m_Encrypted.isSelected()) {
                    BasicSecurityPage.this.m_Password = BasicSecurityPage.getPassword("BasicSecurityPage.CHOOSE_PASSWORD");
                    if (BasicSecurityPage.this.m_Password != null) {
                        String string = BasicSecurityPage.getPassword("BasicSecurityPage.REENTER_PASSWORD");
                        if (!BasicSecurityPage.this.m_Password.equals(string)) {
                            ElixirJ.error(I18N.ERD.getString("BasicSecurityPage.INCORRECT_PASSWORD"));
                            BasicSecurityPage.this.m_Password = null;
                            BasicSecurityPage.this.m_Encrypted.setSelected(false);
                        }
                    } else {
                        BasicSecurityPage.this.m_Encrypted.setSelected(false);
                    }
                } else {
                    String string = BasicSecurityPage.getPassword("BasicSecurityPage.ENTER_PASSWORD");
                    if (string != null) {
                        if (!string.equals(BasicSecurityPage.this.m_Password)) {
                            ElixirJ.error(I18N.ERD.getString("BasicSecurityPage.PASSWORDS_DONT_MATCH"));
                            BasicSecurityPage.this.m_Encrypted.setSelected(true);
                        }
                    } else {
                        BasicSecurityPage.this.m_Encrypted.setSelected(true);
                    }
                }
                BasicSecurityPage.this.m_InternalChange = false;
            }
        });
    }

    public void readOnlyButton() {
        if (this.m_InternalChange) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (BasicSecurityPage.this.m_InternalChange) {
                    return;
                }
                BasicSecurityPage.this.m_InternalChange = true;
                if (BasicSecurityPage.this.m_Encrypted.isSelected()) {
                    String string = BasicSecurityPage.getPassword("BasicSecurityPage.ENTER_PASSWORD");
                    if (string != null) {
                        if (!string.equals(BasicSecurityPage.this.m_Password)) {
                            ElixirJ.error(I18N.ERD.getString("BasicSecurityPage.INCORRECT_PASSWORD"));
                            BasicSecurityPage.this.m_ReadOnly.setSelected(!BasicSecurityPage.this.m_ReadOnly.isSelected());
                        }
                    } else {
                        BasicSecurityPage.this.m_ReadOnly.setSelected(!BasicSecurityPage.this.m_ReadOnly.isSelected());
                    }
                }
                BasicSecurityPage.this.m_InternalChange = false;
            }
        });
    }

    public void hideInternalsButton() {
        if (this.m_InternalChange) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (BasicSecurityPage.this.m_InternalChange) {
                    return;
                }
                BasicSecurityPage.this.m_InternalChange = true;
                if (BasicSecurityPage.this.m_Encrypted.isSelected()) {
                    String string = BasicSecurityPage.getPassword("BasicSecurityPage.ENTER_PASSWORD");
                    if (string != null) {
                        if (!string.equals(BasicSecurityPage.this.m_Password)) {
                            ElixirJ.error(I18N.ERD.getString("BasicSecurityPage.INCORRECT_PASSWORD"));
                            BasicSecurityPage.this.m_HideInternals.setSelected(!BasicSecurityPage.this.m_HideInternals.isSelected());
                        }
                    } else {
                        BasicSecurityPage.this.m_HideInternals.setSelected(!BasicSecurityPage.this.m_HideInternals.isSelected());
                    }
                }
                BasicSecurityPage.this.m_InternalChange = false;
            }
        });
    }

    private static String getPassword(String string) {
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        PasswordDialog passwordDialog = new PasswordDialog(elixirFrame.getFrame(), string);
        elixirFrame.showModal(passwordDialog);
        if (passwordDialog.isOk()) {
            return passwordDialog.getPassword();
        }
        return null;
    }

    @Override
    public IWizardPage getPreviousPage() {
        IWizardPage iWizardPage;
        if (this.m_HideInternals.isSelected() && (iWizardPage = this.m_Wizard.getStartingPage()) != null) {
            return iWizardPage;
        }
        return this.m_PreviousPage;
    }

    public static class PasswordDialog
    extends EscapableDialog {
        private JPasswordField m_Password = new JPasswordField();
        private boolean m_IsOk;

        public PasswordDialog(JFrame jFrame, String string) {
            super((Frame)jFrame, true);
            this.setTitle(I18N.ERD.getString("BasicSecurityPage.PasswordDialog.TITLE"));
            Container container = this.getContentPane();
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            container.add(jPanel);
            jPanel.add((Component)new JLabel(I18N.ERD.getString(string)), "North");
            jPanel.add((Component)this.m_Password, "Center");
            CodeBlock codeBlock = new CodeBlock((Object)this, "ok");
            this.m_Password.addActionListener(codeBlock);
            JPanel jPanel2 = new JPanel(new FlowLayout());
            JButton jButton = SwingFactory.newOkButton(codeBlock);
            JButton jButton2 = SwingFactory.newCancelButton(new CodeBlock((Object)this, "cancel"));
            jPanel2.add(jButton);
            jPanel2.add(jButton2);
            jPanel.add((Component)jPanel2, "South");
            InitialFocusSetter.setInitialFocus(this, this.m_Password);
            I18N.ERD_MAP.injectComponents("BasicSecurityPage.", this);
            this.pack();
            this.setLocationRelativeTo(jFrame);
        }

        public boolean isOk() {
            return this.m_IsOk;
        }

        public String getPassword() {
            return new String(this.m_Password.getPassword());
        }

        public void ok() {
            this.m_IsOk = true;
            this.dispose();
        }

        public void cancel() {
            this.dispose();
        }
    }
}

