/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.input.SAXBuilder;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.ui.wizard.Wizard;
import com.elixirtech.wizard.IConfigWizardPage;
import java.io.InputStream;
import java.util.List;
import javax.swing.Icon;

public abstract class ConfigWizard
extends Wizard {
    private Document m_ConfigDocument;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ConfigWizard.class);

    public ConfigWizard(String string) {
        super(string);
        this.buildPages();
    }

    public Element[] getTypes() {
        Element element = this.m_ConfigDocument.getRootElement();
        List list = element.getChildren("type");
        Element[] elementArray = new Element[list.size()];
        list.toArray(elementArray);
        return elementArray;
    }

    public Element getElement(String string) {
        Element element = this.m_ConfigDocument.getRootElement();
        return element.getChild(string);
    }

    protected void buildPages() {
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            this.m_ConfigDocument = sAXBuilder.build(this.getConfigStream());
            Element element = this.m_ConfigDocument.getRootElement();
            Element element2 = element.getChild("wizard");
            this.buildPages(element2);
        }
        catch (Exception exception) {
            m_Log.error((Object)("Can't read config: " + String.valueOf(exception)), (Throwable)exception);
        }
    }

    protected void buildPages(Element element) {
        for (Element element2 : element.getChildren("page")) {
            String string = element2.getAttributeValue("class");
            if (string == null) continue;
            try {
                Class<?> clazz = Class.forName(string);
                m_Log.debug((Object)("WizardPage :" + string));
                IWizardPage iWizardPage = (IWizardPage)clazz.newInstance();
                iWizardPage.setWizard(this);
                iWizardPage.setIcon(this.getIconResource(element2.getAttributeValue("icon")));
                if (iWizardPage instanceof IConfigWizardPage) {
                    ((IConfigWizardPage)iWizardPage).config(element2);
                }
                this.m_Pages.add(iWizardPage);
            }
            catch (Exception exception) {
                m_Log.error((Object)("Can't load wizard page: " + String.valueOf(exception)), (Throwable)exception);
            }
        }
    }

    protected abstract InputStream getConfigStream();

    public abstract Icon getIconResource(String var1);
}

