/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.util.StringUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateParameter {
    private String m_String;
    private Locale m_Locale;
    private String m_Format;
    private DateFormat m_Formatter;
    private static final String FORMAT = "date\\s*(\\(([^\\),]*)?\\s*(,\"([^\"]*)\")?\\))?";
    private static final Pattern PATTERN = Pattern.compile("date\\s*(\\(([^\\),]*)?\\s*(,\"([^\"]*)\")?\\))?");
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DateParameter.class);

    public DateParameter(String string) {
        this.m_String = string;
        if ("date".equals(this.m_String)) {
            this.initDefaults();
        } else {
            this.parseString();
        }
    }

    public Locale getLocale() {
        return this.m_Locale;
    }

    public String getFormat() {
        return this.m_Format;
    }

    public String toString() {
        return "Locale=" + String.valueOf(this.m_Locale) + " Format=" + this.m_Format;
    }

    private void parseString() {
        Matcher matcher = PATTERN.matcher(this.m_String);
        if (matcher.matches()) {
            String string = null;
            String string2 = null;
            if (matcher.groupCount() >= 2) {
                string = matcher.group(2);
            }
            if (matcher.groupCount() >= 4) {
                string2 = matcher.group(4);
            }
            if (string != null) {
                string = string.trim();
            }
            if (string2 != null) {
                string2 = string2.trim();
            }
            if (StringUtil.isEmpty(string)) {
                this.m_Locale = Locale.getDefault();
            } else {
                String[] stringArray = string.split("_");
                if (stringArray.length == 1) {
                    this.m_Locale = new Locale(stringArray[0]);
                }
                if (stringArray.length == 2) {
                    this.m_Locale = new Locale(stringArray[0], stringArray[1]);
                }
                if (stringArray.length >= 3) {
                    this.m_Locale = new Locale(stringArray[0], stringArray[1], stringArray[2]);
                }
            }
            if (StringUtil.isEmpty(string2)) {
                this.m_Formatter = DateFormat.getDateInstance(1, this.m_Locale);
                this.m_Format = ((SimpleDateFormat)this.m_Formatter).toPattern();
            } else if ("long".equals(string2)) {
                this.m_Formatter = DateFormat.getDateInstance(1, this.m_Locale);
                this.m_Format = ((SimpleDateFormat)this.m_Formatter).toPattern();
            } else if ("medium".equals(string2)) {
                this.m_Formatter = DateFormat.getDateInstance(2, this.m_Locale);
                this.m_Format = ((SimpleDateFormat)this.m_Formatter).toPattern();
            } else if ("short".equals(string2)) {
                this.m_Formatter = DateFormat.getDateInstance(3, this.m_Locale);
                this.m_Format = ((SimpleDateFormat)this.m_Formatter).toPattern();
            } else {
                this.m_Format = string2;
                this.m_Formatter = new SimpleDateFormat(string2);
            }
        } else {
            m_Log.warn((Object)("date expression can't be parsed: " + this.m_String));
            this.initDefaults();
        }
    }

    private void initDefaults() {
        this.m_Locale = Locale.getDefault();
        this.m_Formatter = DateFormat.getDateInstance(1, this.m_Locale);
        this.m_Format = this.m_Formatter instanceof SimpleDateFormat ? ((SimpleDateFormat)this.m_Formatter).toPattern() : "yyyy-MM-dd";
    }
}

