/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.data2.DSLookup;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.ParameterUtil;
import com.elixirtech.data2.SortParameters;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.i18n.I18NBypass;
import com.elixirtech.ui.NonNegativeIntegerDocument;
import com.elixirtech.ui.NumberDocument;
import com.elixirtech.util.StrBuffer;
import com.elixirtech.util.StringUtil;
import com.elixirtech.wizard.DateParameter;
import com.toedter.calendar.JDateChooser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class ParameterPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected ArchLayout m_Layout;
    protected List<Parameter> m_Parameters;
    protected List<JLabel> m_Labels = new ArrayList<JLabel>();
    protected List<JComponent> m_Fields = new ArrayList<JComponent>();
    protected Map<String, JComponent> m_FieldMap = new HashMap<String, JComponent>();
    protected DSLookup m_DSLookup;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ParameterPanel.class);

    public ParameterPanel(DSLookup dSLookup) {
        this.m_Layout = new ArchLayout();
        this.setLayout(this.m_Layout);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_Parameters = new ArrayList<Parameter>();
        this.m_DSLookup = dSLookup;
        this.buildPanel();
    }

    public ParameterPanel(List<Parameter> list, DSLookup dSLookup) {
        this.m_Layout = new ArchLayout();
        this.setLayout(this.m_Layout);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        try {
            this.m_Parameters = SortParameters.sort(list);
        }
        catch (Exception exception) {
            m_Log.error((Object)("Error ordering parameters: " + String.valueOf(exception)));
            this.m_Parameters = list;
        }
        this.m_DSLookup = dSLookup;
        this.buildPanel();
    }

    public String getValue(String string) {
        JComponent jComponent = this.m_FieldMap.get(string);
        if (jComponent instanceof JTextField) {
            String string2 = ((JTextField)jComponent).getText();
            return string2;
        }
        if (jComponent instanceof JComboBox) {
            String string3 = (String)((JComboBox)jComponent).getSelectedItem();
            return string3 != null ? string3 : "";
        }
        if (jComponent instanceof JDateChooser) {
            Date date = ((JDateChooser)jComponent).getDate();
            if (date != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                return simpleDateFormat.format(date);
            }
            return "";
        }
        return "";
    }

    public void setValue(String string, String string2) {
        JComponent jComponent = this.m_FieldMap.get(string);
        if (jComponent instanceof JTextField) {
            ((JTextField)jComponent).setText(string2);
        } else if (jComponent instanceof JComboBox) {
            ((JComboBox)jComponent).setSelectedItem(string2);
        } else if (jComponent instanceof JDateChooser) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                Date date = simpleDateFormat.parse(string2);
                ((JDateChooser)jComponent).setDate(date);
            }
            catch (ParseException parseException) {
                m_Log.warn((Object)("Bad date string ignored: " + string2));
            }
        }
    }

    public void setParameters(List<Parameter> list) {
        try {
            this.m_Parameters = SortParameters.sort(list);
        }
        catch (Exception exception) {
            m_Log.error((Object)("Error ordering parameters: " + String.valueOf(exception)));
            this.m_Parameters = list;
        }
        this.buildPanel();
        this.validate();
    }

    public void setOrderedParameters(List<Parameter> list) {
        this.m_Parameters = list;
        this.buildPanel();
        this.validate();
    }

    public void populateContext(DefaultPushContext defaultPushContext) {
        for (String string : this.m_FieldMap.keySet()) {
            defaultPushContext.setParameter(string, this.getValue(string));
        }
    }

    public void setParameters(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.setValue(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, String> getParameters() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : this.m_FieldMap.keySet()) {
            hashMap.put(string, this.getValue(string));
        }
        return hashMap;
    }

    protected void buildPanel() {
        this.removeAll();
        this.m_Labels.clear();
        this.m_Fields.clear();
        this.m_FieldMap.clear();
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        for (Parameter object2 : this.m_Parameters) {
            if (ParameterUtil.ignoreParam((Parameter)object2)) continue;
            arrayList.add(object2);
        }
        for (Parameter parameter : arrayList) {
            this.addLabel(parameter);
        }
        StrBuffer strBuffer = new StrBuffer();
        Iterator<JLabel> iterator = this.m_Labels.iterator();
        while (iterator.hasNext()) {
            strBuffer.append(iterator.next().getName());
            if (!iterator.hasNext()) continue;
            strBuffer.append(',');
        }
        String string = null;
        for (Parameter parameter : arrayList) {
            JComponent jComponent = this.addField(parameter);
            String string2 = jComponent.getName();
            if (string == null) {
                this.m_Layout.putRight(string2, strBuffer.toString(), 10);
                this.m_Layout.stickTop(string2);
            } else {
                this.m_Layout.alignBelow(string2, string);
            }
            string = string2;
            this.m_Layout.stickRight(string2);
        }
    }

    protected JComponent addField(Parameter parameter) {
        JComponent jComponent;
        String string = parameter.getType();
        if (string.equalsIgnoreCase("password")) {
            jComponent = new JPasswordField(parameter.getDefaultValue());
        } else if (string.equalsIgnoreCase("integer")) {
            jComponent = new JTextField();
            jComponent.setToolTipText(Bundle.ARCH.getString("IntegerFieldTip"));
            ((JTextField)jComponent).setDocument(new NonNegativeIntegerDocument());
            ((JTextField)jComponent).setText(parameter.getDefaultValue());
        } else if (string.equalsIgnoreCase("number")) {
            jComponent = new JTextField();
            jComponent.setToolTipText(Bundle.ARCH.getString("NumberFieldTip"));
            ((JTextField)jComponent).setDocument(new NumberDocument());
            ((JTextField)jComponent).setText(parameter.getDefaultValue());
        } else {
            jComponent = string.startsWith("choice(") ? this.addChoiceField(parameter, string) : (string.startsWith("lookup(") ? this.addLookupField(parameter, string) : (string.startsWith("date") ? this.addDateField(parameter, string) : new JTextField(parameter.getDefaultValue())));
        }
        int n = this.m_Fields.size();
        String string2 = Integer.toString(n) + "-item";
        jComponent.setName(string2);
        this.m_Fields.add(jComponent);
        this.m_FieldMap.put(parameter.getName(), jComponent);
        this.add(jComponent);
        return jComponent;
    }

    protected JComponent addChoiceField(Parameter parameter, String string) {
        Object[] objectArray = ParameterUtil.getChoices((String)string);
        JComboBox<String> jComboBox = new JComboBox<String>(objectArray);
        String string2 = parameter.getDefaultValue();
        Object object = ParameterUtil.getValue((String)string2, (Object[])objectArray);
        jComboBox.setSelectedItem(object);
        return jComboBox;
    }

    protected JComponent addLookupField(Parameter parameter, String string) {
        String[] stringArray = ParameterUtil.getLookup((String)string);
        Object[] objectArray = ParameterUtil.lookupChoices((DSLookup)this.m_DSLookup, (String[])stringArray);
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        String string2 = parameter.getDefaultValue();
        Object object = ParameterUtil.getValue((String)string2, (Object[])objectArray);
        jComboBox.setSelectedItem(object);
        return jComboBox;
    }

    protected JComponent addDateField(Parameter parameter, String string) {
        DateParameter dateParameter = new DateParameter(string);
        String string2 = dateParameter.getFormat();
        Locale locale = dateParameter.getLocale();
        JDateChooser jDateChooser = new JDateChooser();
        jDateChooser.setDateFormatString(string2);
        jDateChooser.setLocale(locale);
        String string3 = parameter.getDefaultValue();
        if (StringUtil.notEmpty(string3)) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                Date date = simpleDateFormat.parse(string3);
                jDateChooser.setDate(date);
            }
            catch (ParseException parseException) {
                m_Log.warn((Object)("Can't parse date: \"" + string3 + "\". It must be in the form " + string2));
            }
        } else {
            jDateChooser.setDate(new Date());
        }
        JDateChooser jDateChooser2 = jDateChooser;
        return jDateChooser2;
    }

    protected void addLabel(Parameter parameter) {
        int n = this.m_Labels.size();
        JLabel jLabel = I18NBypass.newLabel(parameter.getName() + ":");
        String string = Integer.toString(n);
        jLabel.setName(string);
        this.add(jLabel);
        this.m_Layout.stickLeft(string);
        this.m_Layout.vCenter(string, string + "-item");
        this.m_Labels.add(jLabel);
    }
}

