/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.arch.ui.ViewablePasswordField;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.wizard.IWizard;
import com.elixirtech.wizard.PageId;
import com.elixirtech.wizard.WizardPage;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import scala.Option;
import scala.runtime.Scala3RunTime$;

public abstract class RelativeLayoutWizardPage
extends WizardPage {
    private final ArchLayout m_Layout = new ArchLayout();

    public RelativeLayoutWizardPage(IWizard wiz, String p, Option<PageId> np) {
        super(wiz, p, np);
        this.m_Component().setLayout(this.m_Layout());
        this.m_Component().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public ArchLayout m_Layout() {
        return this.m_Layout;
    }

    public JLabel addLabel(String name, JLabel item) {
        this.m_Component().add(name + "-label", item);
        this.stickLeft(name + "-label");
        this.vCenter(name + "-label", name);
        return item;
    }

    public JLabel addLabel(JLabel item) {
        String name = item.getName();
        if (!name.endsWith("-label")) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        String owner = name.substring(0, name.length() - 6);
        this.m_Component().add(item);
        this.stickLeft(name);
        this.vCenter(name, owner);
        return item;
    }

    public JTextField addField(String name, JLabel label) {
        this.addLabel(name, label);
        JTextField item = SwingFactory.newTextField(name);
        this.m_Component().add(item);
        this.stickRight(name);
        return item;
    }

    public JTextField addFieldForLabel(JLabel label) {
        String name = label.getName();
        if (!name.endsWith("-label")) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this.addLabel(label);
        String owner = name.substring(0, name.length() - 6);
        JTextField item = SwingFactory.newTextField(owner);
        this.m_Component().add(item);
        this.stickRight(owner);
        return item;
    }

    public JTextField addLabelledField(String name) {
        String labelName = name + "-label";
        JLabel label = SwingFactory.newLabel(labelName);
        JTextField item = SwingFactory.newTextField(name);
        this.m_Component().add(label);
        this.m_Component().add(item);
        this.stickLeft(labelName);
        this.vCenter(labelName, name);
        this.stickRight(name);
        return item;
    }

    public JTextArea addLabelledFieldArea(String name, int rows) {
        String labelName = name + "-label";
        JLabel label = SwingFactory.newLabel(labelName);
        JTextArea item = SwingFactory.newTextArea(name, rows);
        this.m_Component().add(label);
        this.m_Component().add(item);
        this.stickLeft(labelName);
        this.vCenter(labelName, name);
        this.stickRight(name);
        return item;
    }

    public JTextField addLabelledFieldWithDots(String name, ActionListener al) {
        String labelName = name + "-label";
        String dotsName = name + "-dots";
        JLabel label = SwingFactory.newLabel(labelName);
        JTextField item = SwingFactory.newTextField(name);
        JButton dots = SwingFactory.newDotsButton(dotsName, al);
        this.m_Component().add(label);
        this.m_Component().add(item);
        this.m_Component().add(dots);
        this.stickLeft(labelName);
        this.vCenter(labelName, name);
        this.vCenter(dotsName, name);
        this.stickRight(dotsName);
        this.putLeft(name, dotsName);
        this.setHeight(dotsName, name);
        return item;
    }

    public JTextField addField(String name) {
        JTextField item = SwingFactory.newTextField(name);
        this.m_Component().add(item);
        this.stickRight(name);
        return item;
    }

    public JPasswordField addPasswordField(String name) {
        JPasswordField item = new JPasswordField();
        this.m_Component().add(name, item);
        this.stickRight(name);
        return item;
    }

    public JPasswordField addPassword(String name, JLabel label) {
        this.addLabel(name, label);
        JPasswordField item = new JPasswordField();
        this.m_Component().add(name, item);
        this.stickRight(name);
        return item;
    }

    public ViewablePasswordField addLabelledViewablePasswordField(String name) {
        String labelName = name + "-label";
        JLabel label = SwingFactory.newLabel(labelName);
        ViewablePasswordField item = new ViewablePasswordField();
        item.setName(name);
        this.m_Component().add(label);
        this.m_Component().add(item);
        this.stickLeft(labelName);
        this.vCenter(labelName, name);
        this.stickRight(name);
        return item;
    }

    public JPasswordField addLabelledPassword(String name) {
        String labelName = name + "-label";
        JLabel label = SwingFactory.newLabel(labelName);
        JPasswordField item = new JPasswordField();
        item.setName(name);
        this.m_Component().add(label);
        this.m_Component().add(item);
        this.stickLeft(labelName);
        this.vCenter(labelName, name);
        this.stickRight(name);
        return item;
    }

    public <T> JComboBox<T> addCombo(String name, JLabel label) {
        this.addLabel(name, label);
        JComboBox item = new JComboBox();
        this.m_Component().add(name, item);
        this.stickRight(name);
        return item;
    }

    public <T> JComboBox<T> addCombo(String name) {
        JComboBox item = new JComboBox();
        this.m_Component().add(name, item);
        this.stickRight(name);
        return item;
    }

    public <T> JComboBox<T> addCombo(String name, JLabel label, T[] data) {
        this.addLabel(name, label);
        JComboBox<T> item = new JComboBox<T>(new DefaultComboBoxModel<T>(data));
        this.m_Component().add(name, item);
        this.stickRight(name);
        return item;
    }

    public JCheckBox addCheckBox(String name, JLabel label) {
        this.addLabel(name, label);
        JCheckBox item = new JCheckBox();
        this.m_Component().add(name, item);
        this.stickRight(name);
        return item;
    }

    public JButton addButton(String name, String text) {
        JButton button = new JButton(text);
        this.m_Component().add(name, button);
        return button;
    }

    public JButton addButton(String name, ActionListener al) {
        JButton button = SwingFactory.newButton(name);
        button.addActionListener(al);
        this.m_Component().add(button);
        return button;
    }

    public void putBelow(String name, String above) {
        this.m_Layout().putBelow(name, above);
    }

    public void putBelow(String name, String above, int offset) {
        this.m_Layout().putBelow(name, above, offset);
    }

    public void putAbove(String name, String below) {
        this.m_Layout().putAbove(name, below);
    }

    public void putAbove(String name, String below, int offset) {
        this.m_Layout().putAbove(name, below, offset);
    }

    public void alignBelow(String name, String above) {
        this.m_Layout().alignBelow(name, above);
    }

    public void alignBelow(String name, String above, int offset) {
        this.m_Layout().alignBelow(name, above, offset);
    }

    public void putRight(String name, String left) {
        this.m_Layout().putRight(name, left);
    }

    public void putRight(String name, String left, int offset) {
        this.m_Layout().putRight(name, left, offset);
    }

    public void putLeft(String name, String right) {
        this.m_Layout().putLeft(name, right);
    }

    public void putLeft(String name, String right, int offset) {
        this.m_Layout().putLeft(name, right, offset);
    }

    public void stickLeft(String name) {
        this.m_Layout().stickLeft(name);
    }

    public void stickLeft(String name, int offset) {
        this.m_Layout().stickLeft(name, offset);
    }

    public void stickRight(String name) {
        this.m_Layout().stickRight(name);
    }

    public void stickTop(String name) {
        this.m_Layout().stickTop(name);
    }

    public void stickBottom(String name) {
        this.m_Layout().stickBottom(name);
    }

    public void hCenter(String name) {
        this.m_Layout().hCenter(name);
    }

    public void hCenter(String name, String other) {
        this.m_Layout().hCenter(name, other);
    }

    public void vCenter(String name) {
        this.m_Layout().vCenter(name);
    }

    public void setWidth(String name, String other) {
        this.m_Layout().setWidth(name, other);
    }

    public void setHeight(String name, String other) {
        this.m_Layout().setHeight(name, other);
    }

    public void vCenter(String name, String other) {
        this.m_Layout().vCenter(name, other);
    }
}

