/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard;

import com.elixirtech.i18n.UIFactory;
import com.elixirtech.jdom.Element;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.WizardPage;
import com.elixirtech.wizard.ConfigWizard;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class TypesAndItemsPage
extends WizardPage
implements ListSelectionListener {
    protected JList m_Types = SwingFactory.newList();
    protected JList m_Items = SwingFactory.newList();

    public TypesAndItemsPage(String string, String string2) {
        super(string, string2);
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.buildComponent();
    }

    protected void buildComponent() {
        this.m_Component.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_Component.setLayout(new GridLayout(1, 2, 5, 5));
        this.m_Component.add(new JScrollPane(this.m_Types));
        this.m_Component.add(new JScrollPane(this.m_Items));
        this.m_Types.addListSelectionListener(this);
        this.m_Items.addListSelectionListener(this);
        this.m_Types.setCellRenderer(new Renderer());
        this.m_Items.setCellRenderer(new Renderer());
        this.buildTypes();
        if (this.m_Types.getModel().getSize() > 0) {
            this.m_Types.setSelectedIndex(0);
        }
    }

    protected void buildTypes() {
        ConfigWizard configWizard = (ConfigWizard)this.m_Wizard;
        Element[] elementArray = configWizard.getTypes();
        DefaultListModel<Element> defaultListModel = new DefaultListModel<Element>();
        for (int i = 0; i < elementArray.length; ++i) {
            defaultListModel.addElement(elementArray[i]);
        }
        this.m_Types.setModel(defaultListModel);
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    @Override
    public boolean isPageComplete() {
        return this.m_Types.getSelectedValue() != null && this.m_Items.getSelectedValue() != null;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.m_Types) {
            this.typeSelected((Element)this.m_Types.getSelectedValue());
        } else if (listSelectionEvent.getSource() == this.m_Items) {
            this.itemSelected((Element)this.m_Items.getSelectedValue());
        }
    }

    public abstract void typeSelected(Element var1);

    public void itemSelected(Element element) {
    }

    protected class Renderer
    extends JLabel
    implements ListCellRenderer<Object> {
        public Renderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            Element element = (Element)object;
            String string = element.getAttributeValue("bundle");
            ResourceBundle resourceBundle = UIFactory.getBundle(string);
            String string2 = element.getAttributeValue("name");
            String string3 = resourceBundle.getString(string2);
            this.setText(string3);
            ConfigWizard configWizard = (ConfigWizard)TypesAndItemsPage.this.getWizard();
            this.setIcon(configWizard.getIconResource(element.getAttributeValue("icon")));
            return this;
        }
    }
}

