/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard;

import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.ui.wizard.WizardMessageBar;
import com.elixirtech.wizard.IWizard;
import com.elixirtech.wizard.IWizardContainer;
import com.elixirtech.wizard.IWizardPage;
import com.elixirtech.wizard.WizardDialog$;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class WizardDialog
extends JDialog
implements IWizardContainer,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(WizardDialog.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final JFrame parent;
    private final Function1 wizardFn;
    private Option<IWizardPage> optCurrentPage;
    private final IWizard wizard;
    private final JComponent contentPane;
    private final JRootPane root;
    private final ActionMap actionMap;
    private final InputMap inputMap;
    private final WizardMessageBar m_Message;
    private final JPanel south;
    private final Option previousButton;
    private final Option nextButton;
    private final JButton finishButton;
    private final JButton cancelButton;
    private final int pageCount;

    public static Font MessageFont() {
        return WizardDialog$.MODULE$.MessageFont();
    }

    public static Dimension StandardSize() {
        return WizardDialog$.MODULE$.StandardSize();
    }

    public static Font TitleFont() {
        return WizardDialog$.MODULE$.TitleFont();
    }

    public WizardDialog(JFrame parent, Function1<IWizardContainer, IWizard> wizardFn) {
        None$ none$;
        this.parent = parent;
        this.wizardFn = wizardFn;
        super((Frame)parent, true);
        this.optCurrentPage = None$.MODULE$;
        this.wizard = (IWizard)wizardFn.apply((Object)this);
        this.setTitle("Wizard");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WL());
        this.contentPane = (JComponent)this.getContentPane();
        this.root = this.getRootPane();
        this.actionMap = this.root().getActionMap();
        this.inputMap = this.root().getInputMap(1);
        this.m_Message = new WizardMessageBar();
        this.contentPane().add((Component)this.m_Message(), "North");
        this.south = new JPanel(new FlowLayout(2));
        if (this.wizard().needsPreviousAndNextButtons()) {
            PreviousAction previousAction = new PreviousAction();
            JButton previousButton = new JButton(previousAction);
            this.inputMap().put(KeyStroke.getKeyStroke(37, 512), "previous");
            this.actionMap().put("previous", previousAction);
            this.south().add(previousButton);
            v0 = Some$.MODULE$.apply((Object)previousButton);
        } else {
            v0 = this.previousButton = None$.MODULE$;
        }
        if (this.wizard().needsPreviousAndNextButtons()) {
            NextAction nextAction = new NextAction();
            JButton nextButton = new JButton(nextAction);
            this.inputMap().put(KeyStroke.getKeyStroke(39, 512), "next");
            this.actionMap().put("next", nextAction);
            this.south().add(nextButton);
            none$ = Some$.MODULE$.apply((Object)nextButton);
        } else {
            none$ = None$.MODULE$;
        }
        this.nextButton = none$;
        FinishAction finishAction = new FinishAction();
        this.finishButton = new JButton(finishAction);
        this.inputMap().put(KeyStroke.getKeyStroke(10, 512), "finish");
        this.actionMap().put("finish", finishAction);
        this.south().add(this.finishButton());
        CancelAction cancelAction = new CancelAction();
        this.cancelButton = new JButton(cancelAction);
        this.inputMap().put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.actionMap().put("cancel", cancelAction);
        this.south().add(this.cancelButton());
        this.contentPane().add((Component)this.south(), "South");
        this.pageCount = this.wizard().pages().length();
        this.log().info(this::$init$$$anonfun$1, Line$.MODULE$.apply(78), FullName$.MODULE$.apply("com.elixirtech.wizard.WizardDialog"));
        this.wizard().getStartingPage().foreach((Function1)(JProcedure1 & Serializable)sp2 -> this.showPage((IWizardPage)sp2));
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Function1<IWizardContainer, IWizard> wizardFn() {
        return this.wizardFn;
    }

    public IWizard wizard() {
        return this.wizard;
    }

    public JComponent contentPane() {
        return this.contentPane;
    }

    public JRootPane root() {
        return this.root;
    }

    public ActionMap actionMap() {
        return this.actionMap;
    }

    public InputMap inputMap() {
        return this.inputMap;
    }

    public WizardMessageBar m_Message() {
        return this.m_Message;
    }

    public JPanel south() {
        return this.south;
    }

    public Option<JButton> previousButton() {
        return this.previousButton;
    }

    public Option<JButton> nextButton() {
        return this.nextButton;
    }

    public JButton finishButton() {
        return this.finishButton;
    }

    public JButton cancelButton() {
        return this.cancelButton;
    }

    public int pageCount() {
        return this.pageCount;
    }

    @Override
    public void setVisible(boolean b) {
        this.setSize(WizardDialog$.MODULE$.StandardSize());
        this.setLocationRelativeTo(this.parent);
        super.setVisible(true);
    }

    @Override
    public Option<IWizardPage> currentPage() {
        return this.optCurrentPage;
    }

    @Override
    public void showPage(IWizardPage page) {
        this.log().info(() -> WizardDialog.showPage$$anonfun$1(page), Line$.MODULE$.apply(90), FullName$.MODULE$.apply("com.elixirtech.wizard.WizardDialog.showPage"));
        this.updateCurrentPage(page);
        this.updateButtons();
        this.updateMessage();
        this.updateTitleBar();
        this.repaint();
    }

    private void updateCurrentPage(IWizardPage newPage) {
        this.saveCurrentPage();
        this.loadNewPage(newPage);
        this.validate();
    }

    public void saveCurrentPage() {
        this.optCurrentPage.foreach((Function1)(JProcedure1 & Serializable)cp -> {
            cp.save();
            this.getContentPane().remove(cp.component());
        });
    }

    public void loadNewPage(IWizardPage newPage) {
        this.optCurrentPage = Some$.MODULE$.apply((Object)newPage);
        this.getContentPane().add(newPage.component(), "Center");
        newPage.load();
    }

    @Override
    public void updateButtons() {
        this.previousButton().foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.setEnabled(this.hasPreviousPage$1()));
        this.nextButton().foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.setEnabled(this.hasNextPage$1()));
        this.finishButton().setEnabled(this.wizard().canFinish());
        this.updateMessage();
    }

    public void updateMessage() {
        this.currentPage().foreach((Function1)(JProcedure1 & Serializable)page -> {
            this.m_Message().setTitle(page.getTitle());
            this.m_Message().setIcon(page.getIcon());
            this.m_Message().setMessage(page.getMessage());
            this.m_Message().setError((String)page.getError().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            this.m_Message().repaint();
        });
    }

    @Override
    public void updateTitleBar() {
        this.setTitle(this.wizard().title());
    }

    public void previous() {
        if (this.previousButton().exists((Function1 & Serializable)_$4 -> _$4.isEnabled())) {
            this.currentPage().foreach((Function1)(JProcedure1 & Serializable)_$5 -> _$5.getPreviousPage().foreach((Function1)(JProcedure1 & Serializable)page -> this.showPage((IWizardPage)page)));
            return;
        }
    }

    public void next() {
        if (this.nextButton().exists((Function1 & Serializable)_$6 -> _$6.isEnabled())) {
            this.currentPage().foreach((Function1)(JProcedure1 & Serializable)cp -> cp.getNextPage().foreach((Function1)(JProcedure1 & Serializable)np -> {
                IWizardPage iWizardPage = np;
                IWizardPage iWizardPage2 = cp;
                if (iWizardPage == null ? iWizardPage2 != null : !iWizardPage.equals(iWizardPage2)) {
                    np.setPreviousPage((Option<IWizardPage>)Some$.MODULE$.apply(cp));
                    this.showPage((IWizardPage)np);
                    return;
                }
            }));
            return;
        }
    }

    public void finish() {
        if (this.finishButton().isEnabled() && this.wizard().performFinish()) {
            this.dispose();
            return;
        }
    }

    public void cancel() {
        if (this.cancelButton().isEnabled() && this.wizard().performCancel()) {
            this.dispose();
            return;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.wizard().dispose();
    }

    public String getString(String name) {
        return Bundle.BASE.getString(name);
    }

    private final Object $init$$$anonfun$1() {
        return "Wizard has " + this.pageCount() + " pages";
    }

    private static final Object showPage$$anonfun$1(IWizardPage page$1) {
        return "showPage: " + page$1.name();
    }

    private final boolean hasPreviousPage$1() {
        return this.currentPage().flatMap((Function1 & Serializable)_$1 -> _$1.getPreviousPage()).isDefined();
    }

    private final boolean hasNextPage$1() {
        return this.currentPage().exists((Function1 & Serializable)page -> this.wizard().canFlipToNextPage((IWizardPage)page));
    }

    public class CancelAction
    extends AbstractAction {
        public CancelAction() {
            if (WizardDialog.this == null) {
                throw new NullPointerException();
            }
            super(WizardDialog.this.getString("Cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WizardDialog.this.cancel();
        }

        public final /* synthetic */ WizardDialog com$elixirtech$wizard$WizardDialog$CancelAction$$$outer() {
            return WizardDialog.this;
        }
    }

    public class FinishAction
    extends AbstractAction {
        public FinishAction() {
            if (WizardDialog.this == null) {
                throw new NullPointerException();
            }
            super(WizardDialog.this.getString("Finish"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WizardDialog.this.finish();
        }

        public final /* synthetic */ WizardDialog com$elixirtech$wizard$WizardDialog$FinishAction$$$outer() {
            return WizardDialog.this;
        }
    }

    public class NextAction
    extends AbstractAction {
        public NextAction() {
            if (WizardDialog.this == null) {
                throw new NullPointerException();
            }
            super(WizardDialog.this.getString("Next"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WizardDialog.this.next();
        }

        public final /* synthetic */ WizardDialog com$elixirtech$wizard$WizardDialog$NextAction$$$outer() {
            return WizardDialog.this;
        }
    }

    public class PreviousAction
    extends AbstractAction {
        public PreviousAction() {
            if (WizardDialog.this == null) {
                throw new NullPointerException();
            }
            super(WizardDialog.this.getString("Previous"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WizardDialog.this.previous();
        }

        public final /* synthetic */ WizardDialog com$elixirtech$wizard$WizardDialog$PreviousAction$$$outer() {
            return WizardDialog.this;
        }
    }

    public class WL
    extends WindowAdapter {
        public WL() {
            if (WizardDialog.this == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            WizardDialog.this.cancel();
        }

        public final /* synthetic */ WizardDialog com$elixirtech$wizard$WizardDialog$WL$$$outer() {
            return WizardDialog.this;
        }
    }
}

