/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.barcode;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.categorytype.ICategoryType;
import com.elixirtech.barcode.AztecBean;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.AztecCode;
import com.elixirtech.report2.raw.model.Barcode;
import com.elixirtech.report2.raw.model.BarcodeBasic;
import com.elixirtech.ui.SpringUtilities;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AztecPanel
extends JPanel
implements ChangeListener {
    ElxLoggerJ m_Log = ElxLoggerJ.getLogger(AztecPanel.class);
    private SpinnerNumberModel m_SpinnerModel = new SpinnerNumberModel(0, 0, 100, 1);
    private JSpinner m_Layer = new JSpinner(this.m_SpinnerModel);
    private Barcode m_Barcode;
    private ICategoryType m_BarcodeType;
    private AztecCode m_AztecCode;
    private AztecBean m_AztecBean;

    public AztecPanel(ICategoryType iCategoryType) {
        this.m_BarcodeType = iCategoryType;
        this.build();
    }

    public void build() {
        this.setLayout(new BorderLayout());
        this.m_Layer.addChangeListener(this);
        JPanel jPanel = new JPanel(new SpringLayout());
        JLabel jLabel = SwingFactory.newLabel("layers-label");
        jPanel.add(jLabel);
        jPanel.add(this.m_Layer);
        SpringUtilities.makeCompactGrid(jPanel, 1, 2, 3, 3, 3, 3);
        this.add("North", jPanel);
        this.m_AztecBean = new AztecBean();
        this.m_AztecBean.setSize(new Dimension(120, 120));
        this.m_AztecBean.setCode("http://www.elixirtech.com");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(30, 20, 30, 20));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add("Center", this.m_AztecBean);
        this.add("Center", jPanel2);
        I18N.ERD_MAP.injectComponents("AztecPanel.", this);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    public void setBarcode(Barcode barcode) {
        if (barcode == null) {
            this.m_Barcode = null;
            this.m_Log.warn((Object)"setBarcode Null value for barcode ");
        }
        this.m_Barcode = barcode;
        BarcodeBasic barcodeBasic = barcode.getBarcodeBasic();
        this.m_AztecCode = !(barcodeBasic instanceof AztecCode) || barcodeBasic == null ? new AztecCode() : (AztecCode)barcodeBasic;
        this.m_Barcode.setBarcodeBasic((BarcodeBasic)this.m_AztecCode);
    }

    public void updateFields() {
        if (this.m_AztecCode == null) {
            this.m_Log.warn((Object)"updateFields Null value for m_AztecCode ");
            return;
        }
        this.m_SpinnerModel.setValue(this.m_AztecCode.getLayers());
        this.m_AztecBean.setLayers(this.m_AztecCode.getLayers());
    }

    public void performFinished() {
        if (this.m_AztecBean == null) {
            return;
        }
        Integer n = (Integer)this.m_SpinnerModel.getValue();
        this.m_AztecCode.setLayers(n);
        this.m_AztecBean.setLayers(n);
        if (this.m_Barcode.getBarcodeBasic() == null) {
            this.m_Barcode.setBarcodeBasic((BarcodeBasic)this.m_AztecCode);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Integer n = (Integer)this.m_Layer.getValue();
        this.m_AztecCode.setLayers(n);
        this.m_AztecBean.setLayers(n);
        this.m_AztecBean.repaint();
    }
}

