/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.barcode;

import com.elixirtech.arch.categorytype.ICategoryType;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.barcode.BasicBarcodeRenderer;
import com.elixirtech.barcode.IBarcodeBean;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Barcode;
import com.elixirtech.report2.raw.model.BarcodeBasic;
import com.elixirtech.report2.raw.model.QRCode;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.UnitField;
import com.elixirtech.util.CodeBlock;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;

public class BarcodeBasicPanel
extends JPanel {
    private Barcode m_Barcode;
    private ICategoryType m_BarcodeType;
    private BarcodeBasic m_BarcodeBasic;
    private JCheckBox m_CheckDigit;
    private JCheckBox m_ShowText;
    private JTextField m_LineAngle;
    private UnitField m_HeightUnit;
    private UnitField m_BarWidthUnit;
    private DisplayValuePanel m_DisplayValuePanel;

    public BarcodeBasicPanel(ICategoryType iCategoryType) {
        this.m_BarcodeType = iCategoryType;
        this.build();
    }

    public void setBarcode(Barcode barcode) {
        if (barcode == null) {
            this.m_Barcode = null;
            return;
        }
        this.m_Barcode = barcode;
        this.m_BarcodeBasic = barcode.getBarcodeBasic();
        if (this.m_BarcodeBasic == null || this.m_BarcodeBasic instanceof QRCode) {
            this.m_BarcodeBasic = new BarcodeBasic();
            this.m_BarcodeBasic.setBarWidth(Integer.valueOf(20));
            this.m_BarWidthUnit.setValue(20);
            this.m_HeightUnit.setValue(320);
            this.m_BarcodeBasic.setHeight(this.m_HeightUnit.getValue());
        }
        this.m_Barcode.setBarcodeBasic(this.m_BarcodeBasic);
        this.checkEnabled();
    }

    private void build() {
        ArchLayout archLayout = new ArchLayout();
        this.setLayout(archLayout);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_LineAngle = SwingFactory.newTextField("lineangle-text");
        this.m_HeightUnit = UnitField.newUnitField();
        this.m_HeightUnit.setValue(320);
        this.m_BarWidthUnit = UnitField.newUnitField();
        this.m_CheckDigit = SwingFactory.newCheckBox("checkdigit");
        this.m_ShowText = SwingFactory.newCheckBox("showtext");
        this.m_DisplayValuePanel = new DisplayValuePanel();
        this.add(SwingFactory.newLabel("height-label"));
        this.add("height", this.m_HeightUnit);
        this.add(SwingFactory.newLabel("barwidth-label"));
        this.add("barwidth", this.m_BarWidthUnit);
        this.add(SwingFactory.newLabel("barcodeangle-label"));
        this.add("barcodeangle", this.m_LineAngle);
        this.add(SwingFactory.newLabel("checkdigit-label"));
        this.add("checkdigit", this.m_CheckDigit);
        this.add(SwingFactory.newLabel("showtext-label"));
        this.add("showtext", this.m_ShowText);
        this.add("preview", this.m_DisplayValuePanel);
        archLayout.stickLeft("height-label");
        archLayout.stickLeft("barwidth-label");
        archLayout.stickLeft("barcodeangle-label");
        archLayout.stickLeft("checkdigit-label");
        archLayout.stickLeft("showtext-label");
        archLayout.vCenter("height-label", "height");
        archLayout.vCenter("barwidth-label", "barwidth");
        archLayout.vCenter("barcodeangle-label", "barcodeangle");
        archLayout.vCenter("checkdigit-label", "checkdigit");
        archLayout.vCenter("showtext-label", "showtext");
        archLayout.stickTop("height");
        archLayout.putRight("height", "height-label,barwidth-label,barcodeangle-label,checkdigit-label,showtext-label", 10);
        archLayout.alignBelow("barwidth", "height");
        archLayout.alignBelow("barcodeangle", "barwidth");
        archLayout.alignBelow("checkdigit", "barcodeangle", 10);
        archLayout.alignBelow("showtext", "checkdigit", 10);
        archLayout.stickRight("height");
        archLayout.stickRight("barwidth");
        archLayout.stickRight("barcodeangle");
        archLayout.putRight("preview", "checkdigit,showtext", 20);
        archLayout.putBelow("preview", "barcodeangle", 10);
        archLayout.stickRight("preview");
        archLayout.stickBottom("preview");
        CodeBlock codeBlock = new CodeBlock((Object)this.m_DisplayValuePanel, "update");
        this.m_CheckDigit.addActionListener(codeBlock);
        this.m_ShowText.addActionListener(codeBlock);
        this.m_LineAngle.getDocument().addDocumentListener(codeBlock);
        this.m_HeightUnit.addDocumentListener(codeBlock);
        this.m_BarWidthUnit.addDocumentListener(codeBlock);
        I18N.ERD_MAP.injectComponents("BarcodeBasicPanel.", this);
    }

    public void checkEnabled() {
        boolean bl = !"RM4SCC".equals(this.m_BarcodeType.getType());
        boolean bl2 = this.m_BarcodeType.getType() != null && this.m_BarcodeType.getType().startsWith("RSS-");
        this.m_ShowText.setEnabled(bl);
        this.m_CheckDigit.setEnabled(bl && !bl2);
        this.m_HeightUnit.setEnabled(bl && !bl2);
        this.m_BarWidthUnit.setEnabled(bl);
    }

    public void updateFields() {
        if (this.m_BarcodeBasic == null) {
            return;
        }
        this.m_HeightUnit.setValue(this.m_BarcodeBasic.getHeight());
        this.m_BarWidthUnit.setValue(this.m_BarcodeBasic.getBarWidth());
        if (this.m_BarcodeBasic.getBarcodeAngle() != null) {
            this.m_LineAngle.setText(this.m_BarcodeBasic.getBarcodeAngle().toString());
        } else {
            this.m_LineAngle.setText("0.0");
        }
        if (this.m_BarcodeBasic.isCheckDigit() != null) {
            this.m_CheckDigit.setSelected(this.m_BarcodeBasic.isCheckDigit());
        }
        if (this.m_BarcodeBasic.isShowText() != null) {
            this.m_ShowText.setSelected(this.m_BarcodeBasic.isShowText());
        }
        this.m_DisplayValuePanel.update();
        this.checkEnabled();
    }

    public void performFinished() {
        if (this.m_BarcodeBasic == null) {
            return;
        }
        this.m_BarcodeBasic.setHeight(this.m_HeightUnit.getValue());
        this.m_BarcodeBasic.setBarWidth(this.m_BarWidthUnit.getValue());
        this.m_BarcodeBasic.setBarcodeAngle(this.getDoubleNumber(this.m_LineAngle.getText()));
        this.m_BarcodeBasic.setCheckDigit(Boolean.valueOf(this.m_CheckDigit.isSelected()));
        this.m_BarcodeBasic.setShowText(Boolean.valueOf(this.m_ShowText.isSelected()));
        if (this.m_Barcode.getBarcodeBasic() == null) {
            this.m_Barcode.setBarcodeBasic(this.m_BarcodeBasic);
        }
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.m_HeightUnit.addDocumentListener(documentListener);
        this.m_BarWidthUnit.addDocumentListener(documentListener);
        this.m_LineAngle.getDocument().addDocumentListener(documentListener);
    }

    public void addItemListener(ItemListener itemListener) {
        this.m_CheckDigit.addItemListener(itemListener);
        this.m_ShowText.addItemListener(itemListener);
    }

    public Double getDoubleNumber(String string) {
        Double d = null;
        try {
            d = Double.valueOf(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public String getMessage() {
        Integer n = this.m_HeightUnit.getValue();
        if (n == null) {
            return "Please enter height (numeric value).";
        }
        Integer n2 = this.m_BarWidthUnit.getValue();
        if (n2 == null || n2 < 1) {
            return "Please enter bar width (numeric value >=1 pixel).";
        }
        this.m_DisplayValuePanel.update();
        return null;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    public class DisplayValuePanel
    extends JPanel {
        private IBarcodeBean m_BarcodeBean;

        public DisplayValuePanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createTitledBorder(I18N.ERD.getString("DisplayValuePanel.TITLE")));
        }

        public void update() {
            if (BarcodeBasicPanel.this.m_Barcode.getType() == null || BarcodeBasicPanel.this.m_HeightUnit.getValue() == null || BarcodeBasicPanel.this.m_BarWidthUnit.getValue() == null) {
                return;
            }
            this.removeAll();
            Barcode barcode = new Barcode();
            barcode.setType(BarcodeBasicPanel.this.m_BarcodeType.getType());
            barcode.setCategory(BarcodeBasicPanel.this.m_BarcodeType.getCategory());
            BarcodeBasic barcodeBasic = new BarcodeBasic();
            barcode.setBarcodeBasic(barcodeBasic);
            barcodeBasic.setHeight(BarcodeBasicPanel.this.m_HeightUnit.getValue());
            barcodeBasic.setBarWidth(BarcodeBasicPanel.this.m_BarWidthUnit.getValue());
            barcodeBasic.setBarcodeAngle(BarcodeBasicPanel.this.getDoubleNumber(BarcodeBasicPanel.this.m_LineAngle.getText()));
            barcodeBasic.setCheckDigit(Boolean.valueOf(BarcodeBasicPanel.this.m_CheckDigit.isSelected()));
            barcodeBasic.setShowText(Boolean.valueOf(BarcodeBasicPanel.this.m_ShowText.isSelected()));
            this.m_BarcodeBean = new BasicBarcodeRenderer().getBarcode(barcode);
            JComponent jComponent = this.m_BarcodeBean.getComponent();
            jComponent.setOpaque(true);
            jComponent.setBackground(Color.WHITE);
            this.add("Center", jComponent);
            this.m_BarcodeBean.setCode(BasicBarcodeRenderer.getSampleData((Barcode)barcode));
            super.doLayout();
            this.repaint();
        }

        public String getCode() {
            return BasicBarcodeRenderer.getSampleData((Barcode)BarcodeBasicPanel.this.m_Barcode);
        }
    }
}

