/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.barcode;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.AztecCode;
import com.elixirtech.report2.raw.model.Barcode;
import com.elixirtech.report2.raw.model.BarcodeBasic;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.DataMatrixCode;
import com.elixirtech.report2.raw.model.PDF417Code;
import com.elixirtech.report2.raw.model.QRCode;
import com.elixirtech.ui.ITabComponent;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.ui.wizard.Wizard;
import com.elixirtech.wizard.barcode.BarcodeDataTab;
import com.elixirtech.wizard.barcode.ChooseBarcodePage;
import com.elixirtech.wizard.barcode.ChooseBarcodeTab;
import com.elixirtech.wizard.barcode.SetBarcodeBasicPage;
import com.elixirtech.wizard.barcode.SetBarcodeBasicTab;
import com.elixirtech.wizard.barcode.SetFieldDataPage;
import java.util.List;

public class BarcodeWizard
extends Wizard {
    private ChooseBarcodePage m_ChooseBarcodePage;
    private SetFieldDataPage m_SetFieldPage;
    private SetBarcodeBasicPage m_SetBarcodeBasicPage;
    private Barcode m_Barcode;
    private Barcode m_WorkingCopy;

    public static void getTabs(Barcode barcode, List<ITabComponent> list) {
        ChooseBarcodeTab chooseBarcodeTab = new ChooseBarcodeTab(barcode);
        list.add(chooseBarcodeTab);
        list.add(new BarcodeDataTab(barcode));
        list.add(new SetBarcodeBasicTab(barcode, chooseBarcodeTab));
    }

    public BarcodeWizard(Barcode barcode, boolean bl) {
        super(I18N.ERD.getString("BarcodeWizard.title"));
        this.setReadOnly(bl);
        this.setBarcode(barcode);
        this.buildPages();
    }

    public void setBarcode(Barcode barcode) {
        this.m_Barcode = barcode;
        this.m_WorkingCopy = new Barcode();
        this.copy(this.m_Barcode, this.m_WorkingCopy);
        this.m_WorkingCopy.setParent(this.m_Barcode.getParent());
    }

    public Barcode getBarcode() {
        return this.m_WorkingCopy;
    }

    @Override
    public boolean performFinish() {
        super.performFinish();
        this.m_ChooseBarcodePage.performFinish();
        this.m_SetFieldPage.performFinish();
        this.m_SetBarcodeBasicPage.performFinished();
        this.copy(this.m_WorkingCopy, this.m_Barcode);
        return true;
    }

    protected void buildPages() {
        this.m_ChooseBarcodePage = new ChooseBarcodePage();
        this.m_SetFieldPage = new SetFieldDataPage();
        this.m_SetBarcodeBasicPage = new SetBarcodeBasicPage();
        this.m_Pages.add(this.m_ChooseBarcodePage);
        this.m_Pages.add(this.m_SetFieldPage);
        this.m_Pages.add(this.m_SetBarcodeBasicPage);
        for (IWizardPage iWizardPage : this.m_Pages) {
            iWizardPage.setWizard(this);
        }
    }

    protected void copy(Barcode barcode, Barcode barcode2) {
        ControlSource controlSource;
        ControlSource controlSource2;
        String string = barcode.getType();
        barcode2.setType(barcode.getType());
        barcode2.setCategory(barcode.getCategory());
        try {
            controlSource2 = barcode.getControlSource();
            if (controlSource2 != null) {
                controlSource = (ControlSource)controlSource2.shallowCopy();
                controlSource.setText(controlSource2.getText());
                barcode2.setControlSource(controlSource);
            }
        }
        catch (Exception exception) {
            ElxLoggerJ.getLogger(BarcodeWizard.class).warn((Object)"Can't clone Barcode ControlSource");
        }
        controlSource2 = barcode.getBarcodeBasic();
        if ("QRCode".equals(string)) {
            if (controlSource2 != null) {
                controlSource = null;
                try {
                    controlSource = (QRCode)((QRCode)controlSource2).shallowCopy();
                    barcode2.setBarcodeBasic((BarcodeBasic)controlSource);
                }
                catch (Exception exception) {
                    ElxLoggerJ.getLogger(BarcodeWizard.class).warn((Object)"Can't clone QRCode");
                }
            }
        } else if ("PDF417".equals(string)) {
            if (controlSource2 != null) {
                controlSource = null;
                try {
                    controlSource = (PDF417Code)((PDF417Code)controlSource2).shallowCopy();
                    barcode2.setBarcodeBasic((BarcodeBasic)controlSource);
                }
                catch (Exception exception) {
                    ElxLoggerJ.getLogger(BarcodeWizard.class).warn((Object)"Can't clone PDF417");
                }
            }
        } else if ("DataMatrix".equals(string)) {
            if (controlSource2 != null) {
                controlSource = null;
                try {
                    controlSource = (DataMatrixCode)((DataMatrixCode)controlSource2).shallowCopy();
                    barcode2.setBarcodeBasic((BarcodeBasic)controlSource);
                }
                catch (Exception exception) {
                    ElxLoggerJ.getLogger(BarcodeWizard.class).warn((Object)"Can't clone DataMatrix");
                }
            }
        } else if ("Aztec".equals(string)) {
            if (controlSource2 != null) {
                controlSource = null;
                try {
                    controlSource = (AztecCode)((AztecCode)controlSource2).shallowCopy();
                    barcode2.setBarcodeBasic((BarcodeBasic)controlSource);
                }
                catch (Exception exception) {
                    ElxLoggerJ.getLogger(BarcodeWizard.class).warn((Object)"Can't clone AztecCode");
                }
            }
        } else if (controlSource2 != null) {
            try {
                controlSource = (BarcodeBasic)controlSource2.shallowCopy();
                barcode2.setBarcodeBasic((BarcodeBasic)controlSource);
            }
            catch (Exception exception) {
                ElxLoggerJ.getLogger(BarcodeWizard.class).warn((Object)"Can't clone BarcodeBasic");
            }
        }
    }
}

