/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.barcode;

import com.elixirtech.arch.categorytype.CategoryTypeSelectionPanel;
import com.elixirtech.arch.categorytype.ICategoryType;
import com.elixirtech.arch.categorytype.ICategoryTypeRegistry;
import com.elixirtech.barcode.BarcodeRegistry;
import com.elixirtech.icons.BarcodeIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Barcode;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardContainer;
import com.elixirtech.ui.wizard.WizardPage;
import com.elixirtech.wizard.barcode.BarcodeWizard;
import java.awt.BorderLayout;
import java.awt.Component;

public class ChooseBarcodePage
extends WizardPage
implements ICategoryType {
    public static final String NAME = "ChooseBarcode";
    protected ICategoryTypeRegistry m_CategoryRegistry = BarcodeRegistry.BARCODE_REGISTRY;
    protected CategoryTypeSelectionPanel m_Panel;
    protected String m_Category;
    protected String m_Type;

    public ChooseBarcodePage() {
        super(NAME, "SelectField");
        this.setIcon(BarcodeIcons.BARCODE_IMAGE);
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        BarcodeWizard barcodeWizard = (BarcodeWizard)this.m_Wizard;
        this.m_Category = barcodeWizard.getBarcode().getCategory();
        this.m_Type = barcodeWizard.getBarcode().getType();
        this.m_Panel = new CategoryTypeSelectionPanel(this, this.m_CategoryRegistry);
        this.m_Component.setLayout(new BorderLayout());
        this.m_Component.add((Component)this.m_Panel, "Center");
        this.m_Panel.updateFields();
        FieldWatcher fieldWatcher = new FieldWatcher(this.m_Wizard);
        this.m_Panel.addListSelectionListener(fieldWatcher);
        I18N.ERD_MAP.injectObject(null, this, "ChooseBarcodePage");
        I18N.ERD_MAP.injectComponents("ChooseBarcodePage.", this.m_Component);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    @Override
    public String getCategory() {
        return this.m_Category;
    }

    @Override
    public String getType() {
        return this.m_Type;
    }

    @Override
    public void setCategory(String string) {
        this.m_Category = string;
    }

    @Override
    public void setType(String string) {
        this.m_Type = string;
    }

    @Override
    public boolean isPageComplete() {
        boolean bl = true;
        this.setError(null);
        if (!this.m_Panel.isCategorySelected()) {
            this.setError(I18N.ERD.getString("Wizard.category-select"));
            bl = false;
        } else if (!this.m_Panel.isTypeSelected()) {
            this.setError(I18N.ERD.getString("Wizard.category-type"));
            bl = false;
        }
        IWizardContainer iWizardContainer = this.m_Wizard.getContainer();
        if (iWizardContainer != null) {
            iWizardContainer.updateMessage();
        }
        return bl;
    }

    public void performFinish() {
        Barcode barcode = ((BarcodeWizard)this.m_Wizard).getBarcode();
        barcode.setCategory(this.m_Category);
        barcode.setType(this.m_Type);
    }
}

