/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.barcode;

import com.elixirtech.arch.categorytype.CategoryTypeSelectionPanel;
import com.elixirtech.arch.categorytype.ICategoryType;
import com.elixirtech.barcode.BarcodeRegistry;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Barcode;
import com.elixirtech.ui.ITabComponent;
import com.elixirtech.ui.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ChooseBarcodeTab
extends JPanel
implements ICategoryType,
ITabComponent {
    static final String QR = "QRCode";
    static final String RM = "RM4SCC";
    static final String PDF417 = "PDF417";
    static final String AZTEC = "Aztec";
    protected CategoryTypeSelectionPanel m_CategoryTypeSelectionPanel;
    protected BarcodeRegistry m_CategoryRegistry;
    private Barcode m_Barcode;
    private String m_Cat;
    private String m_Type;
    private String m_OldType;

    public ChooseBarcodeTab(Barcode barcode) {
        this.setLayout(new BorderLayout());
        this.m_Barcode = barcode;
        this.m_CategoryRegistry = (BarcodeRegistry)BarcodeRegistry.BARCODE_REGISTRY.clone();
        this.filter();
        this.m_CategoryTypeSelectionPanel = new CategoryTypeSelectionPanel(this, this.m_CategoryRegistry);
        this.add((Component)this.m_CategoryTypeSelectionPanel, "Center");
        this.m_Cat = this.m_Barcode.getCategory();
        this.m_OldType = this.m_Type = this.m_Barcode.getType();
        this.entered();
        I18N.ERD_MAP.injectComponents("ChooseBarcodeTab.", this);
    }

    public void filter() {
    }

    @Override
    public String getName() {
        return I18N.ERD.getString("ChooseBarcodeTab.name");
    }

    @Override
    public String getMessage() {
        return I18N.ERD.getString("ChooseBarcodeTab.message");
    }

    @Override
    public void entered() {
        this.m_CategoryTypeSelectionPanel.updateFields();
    }

    @Override
    public void exited() {
        this.m_CategoryTypeSelectionPanel.updateFields();
    }

    @Override
    public boolean containsProperty(String string) {
        return false;
    }

    @Override
    public String getCategory() {
        return this.m_Cat;
    }

    @Override
    public void setCategory(String string) {
        this.m_Cat = string;
    }

    @Override
    public String getType() {
        return this.m_Type;
    }

    @Override
    public void setType(String string) {
        this.m_Type = string;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void performFinish() {
        if (!this.m_OldType.equals(this.m_Type)) {
            this.m_Barcode.setBarcodeBasic(null);
        }
        this.m_Barcode.setCategory(this.m_Cat);
        this.m_Barcode.setType(this.m_Type);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }
}

