/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.barcode;

import com.elixirtech.arch.categorytype.ICategoryType;
import com.elixirtech.barcode.DataMatrixBean;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Barcode;
import com.elixirtech.report2.raw.model.BarcodeBasic;
import com.elixirtech.report2.raw.model.DataMatrixCode;
import com.elixirtech.ui.SpringUtilities;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public class DataMatrixPanel
extends JPanel
implements ItemListener {
    private I18NComboBox m_Shape;
    private DataMatrixBean m_DataMatrixBean;
    private Barcode m_Barcode;
    private ICategoryType m_BarcodeType;
    private DataMatrixCode m_DataMatrixCode;
    static final String[] SHAPE_KEYS = new String[]{"DataMatrix.NONE", "DataMatrix.RECTANGLE", "DataMatrix.SQUARE"};
    static final String[] SHAPE_VALUES = new String[]{DataMatrixBean.FORCE_NONE(), DataMatrixBean.FORCE_RECTANGLE(), DataMatrixBean.FORCE_SQUARE()};

    public DataMatrixPanel(ICategoryType iCategoryType) {
        this.m_BarcodeType = iCategoryType;
        this.build();
    }

    public void build() {
        this.setLayout(new BorderLayout());
        this.m_Shape = I18NComboBox.apply(SHAPE_VALUES, "i18n/erd", SHAPE_KEYS);
        this.m_Shape.setSelectedId("None");
        this.m_Shape.setName("shape");
        this.m_Shape.addItemListener(this);
        JPanel jPanel = new JPanel(new SpringLayout());
        JLabel jLabel = SwingFactory.newLabel("shape-symbol-label");
        jPanel.add(jLabel);
        jPanel.add(this.m_Shape);
        SpringUtilities.makeCompactGrid(jPanel, 1, 2, 3, 3, 3, 3);
        this.add("North", jPanel);
        this.m_DataMatrixBean = new DataMatrixBean();
        this.m_DataMatrixBean.setSize(new Dimension(120, 120));
        this.m_DataMatrixBean.setCode("http://www.elixirtech.com");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(30, 20, 30, 20));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add("Center", this.m_DataMatrixBean);
        this.add("Center", jPanel2);
        I18N.ERD_MAP.injectComponents("DataMatrixPanel.", this);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    public void setBarcode(Barcode barcode) {
        if (barcode == null) {
            this.m_Barcode = null;
            return;
        }
        this.m_Barcode = barcode;
        BarcodeBasic barcodeBasic = barcode.getBarcodeBasic();
        if (!(barcodeBasic instanceof DataMatrixCode) || barcodeBasic == null) {
            this.m_DataMatrixCode = new DataMatrixCode();
            this.m_DataMatrixCode.setShape(DataMatrixBean.FORCE_NONE());
        } else {
            this.m_DataMatrixCode = (DataMatrixCode)barcodeBasic;
        }
        this.m_Barcode.setBarcodeBasic((BarcodeBasic)this.m_DataMatrixCode);
    }

    public void updateFields() {
        if (this.m_DataMatrixCode == null) {
            return;
        }
        this.m_Shape.setSelectedId(this.m_DataMatrixCode.getShape());
        this.m_DataMatrixBean.setSymbolShape(this.m_DataMatrixCode.getShape());
    }

    public void performFinished() {
        if (this.m_DataMatrixBean == null) {
            return;
        }
        String string = this.m_Shape.getSelectedId();
        this.m_DataMatrixCode.setShape(string);
        this.m_DataMatrixBean.setSymbolShape(string);
        if (this.m_Barcode.getBarcodeBasic() == null) {
            this.m_Barcode.setBarcodeBasic((BarcodeBasic)this.m_DataMatrixCode);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        String string = this.m_Shape.getSelectedId();
        this.m_DataMatrixCode.setShape(string);
        this.m_DataMatrixBean.setSymbolShape(string);
        this.m_DataMatrixBean.repaint();
    }
}

