/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.barcode;

import com.elixirtech.arch.categorytype.ICategoryType;
import com.elixirtech.barcode.PDF417Bean;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Barcode;
import com.elixirtech.report2.raw.model.BarcodeBasic;
import com.elixirtech.report2.raw.model.PDF417Code;
import com.elixirtech.ui.SpringUtilities;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public class PDF417Panel
extends JPanel {
    private I18NComboBox m_CompactMode;
    private JCheckBox m_Compaction;
    private PDF417Bean m_PDF417Bean;
    private Barcode m_Barcode;
    private ICategoryType m_BarcodeType;
    private PDF417Code m_PDF417Code;
    static final String[] COMPACT_KEYS = new String[]{"PDF417.AUTO", "PDF417.TEXT", "PDF417.NUMERIC", "PDF417.BYTE"};
    static final String[] COMPACT_VALUES = new String[]{"Auto", "Text", "Numeric", "Byte"};

    public PDF417Panel(ICategoryType iCategoryType) {
        this.m_BarcodeType = iCategoryType;
        this.build();
    }

    public void build() {
        this.setLayout(new BorderLayout());
        this.m_Compaction = new JCheckBox();
        this.m_Compaction.setName("is-compact");
        this.m_CompactMode = I18NComboBox.apply(COMPACT_VALUES, "i18n/erd", COMPACT_KEYS);
        this.m_CompactMode.setSelectedId("Auto");
        this.m_CompactMode.setName("compact-mode");
        JPanel jPanel = new JPanel(new SpringLayout());
        JLabel jLabel = SwingFactory.newLabel("is-compact-label");
        jPanel.add(jLabel);
        jPanel.add(this.m_Compaction);
        JLabel jLabel2 = SwingFactory.newLabel("compact-mode-label");
        jPanel.add(jLabel2);
        jPanel.add(this.m_CompactMode);
        SpringUtilities.makeCompactGrid(jPanel, 2, 2, 3, 3, 3, 3);
        this.add("North", jPanel);
        this.m_PDF417Bean = new PDF417Bean();
        this.m_PDF417Bean.setSize(new Dimension(120, 120));
        this.m_PDF417Bean.setCode("http://www.elixirtech.com");
        this.add("Center", this.m_PDF417Bean);
        I18N.ERD_MAP.injectComponents("PDF417Panel.", this);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    public void setBarcode(Barcode barcode) {
        if (barcode == null) {
            this.m_Barcode = null;
            return;
        }
        this.m_Barcode = barcode;
        BarcodeBasic barcodeBasic = barcode.getBarcodeBasic();
        if (!(barcodeBasic instanceof PDF417Code) || barcodeBasic == null) {
            this.m_PDF417Code = new PDF417Code();
            this.m_PDF417Code.setCompaction(Boolean.valueOf(false));
        } else {
            this.m_PDF417Code = (PDF417Code)barcodeBasic;
        }
        this.m_Barcode.setBarcodeBasic((BarcodeBasic)this.m_PDF417Code);
    }

    public void updateFields() {
        if (this.m_PDF417Code == null) {
            return;
        }
        this.m_CompactMode.setSelectedId(this.m_PDF417Code.getCompactMode());
        this.m_Compaction.setSelected(this.m_PDF417Code.isCompaction());
    }

    public void performFinished() {
        if (this.m_PDF417Code == null) {
            return;
        }
        String string = this.m_CompactMode.getSelectedId();
        boolean bl = this.m_Compaction.isSelected();
        this.m_PDF417Code.setCompactMode(string);
        this.m_PDF417Code.setCompaction(Boolean.valueOf(bl));
        if (this.m_Barcode.getBarcodeBasic() == null) {
            this.m_Barcode.setBarcodeBasic((BarcodeBasic)this.m_PDF417Code);
        }
    }
}

