/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.barcode;

import com.elixirtech.arch.categorytype.ICategoryType;
import com.elixirtech.barcode.QRCodeBean;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Barcode;
import com.elixirtech.report2.raw.model.BarcodeBasic;
import com.elixirtech.report2.raw.model.QRCode;
import com.elixirtech.ui.SpringUtilities;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public class QRCodePanel
extends JPanel {
    private Barcode m_Barcode;
    private ICategoryType m_BarcodeType;
    private QRCode m_QRCode;
    private JComboBox<String> m_CharacterSet;
    private I18NComboBox m_ErrorCorrection;
    private QRCodeBean m_QRCodeBean;
    static final String[] ERROR_KEYS = new String[]{"QRCode.L", "QRCode.M", "QRCode.Q", "QRCode.H"};
    static final String[] ERROR_CORRECTIONS = new String[]{"L", "M", "Q", "H"};

    public QRCodePanel(ICategoryType iCategoryType) {
        this.m_BarcodeType = iCategoryType;
        this.build();
    }

    public void setBarcode(Barcode barcode) {
        if (barcode == null) {
            this.m_Barcode = null;
            return;
        }
        this.m_Barcode = barcode;
        BarcodeBasic barcodeBasic = barcode.getBarcodeBasic();
        if (!(barcodeBasic instanceof QRCode) || barcodeBasic == null) {
            this.m_QRCode = new QRCode();
            this.m_QRCode.setErrorCorrectionLevel("L");
        } else {
            this.m_QRCode = (QRCode)barcodeBasic;
        }
        this.m_Barcode.setBarcodeBasic((BarcodeBasic)this.m_QRCode);
    }

    private void build() {
        this.setLayout(new BorderLayout());
        this.m_ErrorCorrection = I18NComboBox.apply(ERROR_CORRECTIONS, "i18n/erd", ERROR_KEYS);
        this.m_ErrorCorrection.setSelectedId("L");
        this.m_ErrorCorrection.setName("error-correction");
        this.m_CharacterSet = new JComboBox<String>(new String[]{"", "Shift_JIS"});
        this.m_CharacterSet.setName("character-set");
        this.m_CharacterSet.setEditable(true);
        JPanel jPanel = new JPanel(new SpringLayout());
        jPanel.add(SwingFactory.newLabel("error-correction-label"));
        jPanel.add(this.m_ErrorCorrection);
        jPanel.add(SwingFactory.newLabel("character-set-label"));
        jPanel.add(this.m_CharacterSet);
        SpringUtilities.makeCompactGrid(jPanel, 2, 2, 3, 3, 3, 2);
        this.add("North", jPanel);
        this.m_QRCodeBean = new QRCodeBean();
        this.m_QRCodeBean.setSize(new Dimension(120, 120));
        this.m_QRCodeBean.setCode("http://www.elixirtech.com");
        this.add("Center", this.m_QRCodeBean);
        I18N.ERD_MAP.injectComponents("QRCodePanel.", this);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    public void updateFields() {
        if (this.m_QRCode == null) {
            return;
        }
        this.m_ErrorCorrection.setSelectedId(String.valueOf(this.m_QRCode.getErrorCorrectionLevel()));
        String string = this.m_QRCode.getCharacterSet();
        if (string != null) {
            this.m_CharacterSet.setSelectedItem(string);
        } else {
            this.m_CharacterSet.setSelectedItem("");
        }
    }

    public void performFinished() {
        if (this.m_QRCode == null) {
            return;
        }
        String string = this.m_ErrorCorrection.getSelectedId();
        this.m_QRCode.setErrorCorrectionLevel(string);
        Object object = this.m_CharacterSet.getSelectedItem();
        if (object != null) {
            this.m_QRCode.setCharacterSet(object.toString());
        } else {
            this.m_QRCode.setCharacterSet("");
        }
        if (this.m_Barcode.getBarcodeBasic() == null) {
            this.m_Barcode.setBarcodeBasic((BarcodeBasic)this.m_QRCode);
        }
    }
}

