/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.barcode;

import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Barcode;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.wizard.barcode.AztecPanel;
import com.elixirtech.wizard.barcode.BarcodeBasicPanel;
import com.elixirtech.wizard.barcode.ChooseBarcodeTab;
import com.elixirtech.wizard.barcode.DataMatrixPanel;
import com.elixirtech.wizard.barcode.PDF417Panel;
import com.elixirtech.wizard.barcode.QRCodePanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SetBarcodeBasicTab
extends TabComponent
implements ChangeListener {
    private Barcode m_Barcode;
    private JPanel m_CardPanel;
    private CardLayout m_CardLayout;
    private ChooseBarcodeTab m_CategoryType;
    private QRCodePanel m_QRCodePanel;
    private PDF417Panel m_PDF417Panel;
    private AztecPanel m_AztecPanel;
    private DataMatrixPanel m_DataMatrixPanel;
    private BarcodeBasicPanel m_BarcodeBasicPanel;

    public SetBarcodeBasicTab(Barcode barcode, ChooseBarcodeTab chooseBarcodeTab) {
        this.setLayout(new BorderLayout());
        this.m_CategoryType = chooseBarcodeTab;
        this.m_BarcodeBasicPanel = new BarcodeBasicPanel(this.m_CategoryType);
        this.m_QRCodePanel = new QRCodePanel(this.m_CategoryType);
        this.m_PDF417Panel = new PDF417Panel(this.m_CategoryType);
        this.m_DataMatrixPanel = new DataMatrixPanel(this.m_CategoryType);
        this.m_AztecPanel = new AztecPanel(this.m_CategoryType);
        this.m_CardLayout = new CardLayout();
        this.m_CardPanel = new JPanel(this.m_CardLayout);
        this.m_CardPanel.add("Basic", this.m_BarcodeBasicPanel);
        this.m_CardPanel.add("QRCode", this.m_QRCodePanel);
        this.m_CardPanel.add("PDF417", this.m_PDF417Panel);
        this.m_CardPanel.add("DataMatrix", this.m_DataMatrixPanel);
        this.m_CardPanel.add("Aztec", this.m_AztecPanel);
        this.add("Center", this.m_CardPanel);
        this.m_Barcode = barcode;
        this.entered();
    }

    @Override
    public String getName() {
        return I18N.ERD.getString("SetBarcodeBasicTab.name");
    }

    @Override
    public String getMessage() {
        return I18N.ERD.getString("SetBarcodeBasicTab.message");
    }

    @Override
    public void performFinish() {
        String string = this.m_CategoryType.getType();
        if ("QRCode".equals(string)) {
            this.m_QRCodePanel.performFinished();
        } else if ("PDF417".equals(string)) {
            this.m_PDF417Panel.performFinished();
        } else if ("DataMatrix".equals(string)) {
            this.m_DataMatrixPanel.performFinished();
        } else if ("Aztech".equals(string)) {
            this.m_AztecPanel.performFinished();
        } else {
            this.m_BarcodeBasicPanel.performFinished();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_BarcodeBasicPanel.setEnabled(bl);
        this.m_QRCodePanel.setEnabled(bl);
        this.m_PDF417Panel.setEnabled(bl);
        this.m_DataMatrixPanel.setEnabled(bl);
        this.m_AztecPanel.setEnabled(bl);
    }

    @Override
    public void entered() {
        String string = this.m_CategoryType.getType();
        if ("QRCode".equals(string)) {
            this.m_CardLayout.show(this.m_CardPanel, "QRCode");
            this.m_QRCodePanel.setBarcode(this.m_Barcode);
            this.m_BarcodeBasicPanel.setBarcode(null);
            this.m_QRCodePanel.updateFields();
        } else if ("PDF417".equals(string)) {
            this.m_CardLayout.show(this.m_CardPanel, "PDF417");
            this.m_PDF417Panel.setBarcode(this.m_Barcode);
            this.m_BarcodeBasicPanel.setBarcode(null);
            this.m_PDF417Panel.updateFields();
        } else if ("DataMatrix".equals(string)) {
            this.m_CardLayout.show(this.m_CardPanel, "DataMatrix");
            this.m_DataMatrixPanel.setBarcode(this.m_Barcode);
            this.m_BarcodeBasicPanel.setBarcode(null);
            this.m_DataMatrixPanel.updateFields();
        } else if ("Aztec".equals(string)) {
            this.m_CardLayout.show(this.m_CardPanel, "Aztec");
            this.m_AztecPanel.setBarcode(this.m_Barcode);
            this.m_BarcodeBasicPanel.setBarcode(null);
            this.m_AztecPanel.updateFields();
        } else {
            this.m_QRCodePanel.setBarcode(null);
            this.m_PDF417Panel.setBarcode(null);
            this.m_DataMatrixPanel.setBarcode(null);
            this.m_BarcodeBasicPanel.setBarcode(this.m_Barcode);
            this.m_QRCodePanel.setBarcode(null);
            this.m_BarcodeBasicPanel.updateFields();
            this.m_CardLayout.show(this.m_CardPanel, "Basic");
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.m_CategoryType.performFinish();
        this.entered();
    }
}

