/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.callback;

import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.wizard.TabbedWizardPage;
import com.elixirtech.editor.JEditor;
import com.elixirtech.editor.REPlain;
import com.elixirtech.icons.StandardIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.FileLoadDialog;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.FieldWatcher;
import com.elixirtech.ui.wizard.IFinishPage;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.wizard.data.IDataPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileReader;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.StyledEditorKit;

public class CallbackDataPage
extends TabbedWizardPage
implements IFinishPage {
    protected FieldWatcher m_FieldWatcher;

    protected CallbackDataPage(String string) {
        this(string, null);
    }

    protected CallbackDataPage(String string, String string2) {
        super(string, string2);
    }

    @Override
    public void setWizard(IWizard iWizard) {
        this.m_FieldWatcher = new FieldWatcher(iWizard);
        super.setWizard(iWizard);
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void doFinish() {
        this.performFinish();
    }

    protected class OpenFileAction
    extends AbstractAction {
        protected String m_ActionName = "Open A File";
        protected String m_ActionDesc = "Opens A File Into The Editor";
        protected String m_FileDesc = "File";
        protected String m_FilterBy = null;
        protected String m_FilterByDesc = null;
        private JEditor m_Editor = null;
        private FileLoadDialog m_FileLoadDialog = null;

        public OpenFileAction(JEditor jEditor) {
            this.m_Editor = jEditor;
        }

        protected void init() {
            this.putValue("Name", this.m_ActionName);
            this.putValue("SmallIcon", StandardIcons.OPEN);
            this.putValue("ShortDescription", this.m_ActionDesc);
            this.m_FileLoadDialog = new FileLoadDialog();
            if (this.m_FilterBy != null) {
                this.m_FileLoadDialog.addFilter(this.m_FilterBy, this.m_FilterByDesc);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (this.m_FileLoadDialog.showOpenDialog(CallbackDataPage.this.getComponent()) == 0) {
                    AbstractDocument abstractDocument;
                    File file = this.m_FileLoadDialog.getSelectedFile();
                    this.m_Editor.read(new FileReader(file), (Object)this.m_FileDesc);
                    AbstractDocument abstractDocument2 = abstractDocument = (AbstractDocument)this.m_Editor.getDocument();
                    Objects.requireNonNull(abstractDocument2);
                    AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(abstractDocument2, 0, abstractDocument.getLength(), DocumentEvent.EventType.CHANGE);
                    CallbackDataPage.this.m_FieldWatcher.changedUpdate(defaultDocumentEvent);
                }
            }
            catch (Exception exception) {
                ElixirJ.error(I18N.ERD.getString("CallbackDataPage.error-opening") + this.m_FileDesc + ": " + String.valueOf(exception), exception);
            }
        }
    }

    protected class EditorKitPanel
    extends JPanel
    implements IDataPanel {
        protected JToolBar m_Toolbar = SwingFactory.newToolBar();
        protected JEditor m_Editor = null;

        public EditorKitPanel() {
            this.setLayout(new BorderLayout());
            this.m_Editor = new JEditor("", REPlain.kit());
            JScrollPane jScrollPane = new JScrollPane(this.m_Editor);
            this.add((Component)jScrollPane, "Center");
        }

        public EditorKitPanel(StyledEditorKit styledEditorKit) {
            this();
            this.setEditorKit(styledEditorKit);
        }

        public void setEditorKit(StyledEditorKit styledEditorKit) {
            this.m_Editor.setEditorKit(styledEditorKit);
        }

        public void addToolBarAction(AbstractAction abstractAction) {
            if (abstractAction == null) {
                abstractAction = new OpenFileAction(this.m_Editor);
            }
            this.m_Toolbar.setOrientation(1);
            this.m_Toolbar.add(abstractAction);
            this.add((Component)this.m_Toolbar, "West");
        }

        public JEditor getEditor() {
            return this.m_Editor;
        }

        public String getText() {
            return this.m_Editor.getText();
        }

        public void addDocumentListener(DocumentListener documentListener) {
            this.m_Editor.getDocument().addDocumentListener(documentListener);
        }

        @Override
        public ControlSource getControlSource() {
            ControlSource controlSource = new ControlSource();
            controlSource.setType("Literal");
            String string = this.getText().trim();
            controlSource.setText(string);
            return controlSource;
        }
    }
}

