/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.callback;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.CallbackElement;
import com.elixirtech.ui.wizard.IFinishPage;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.ui.wizard.PageHolder;
import com.elixirtech.ui.wizard.Wizard;
import com.elixirtech.wizard.callback.CallbackStartPage;
import com.elixirtech.wizard.callback.WizardRegistry;
import java.util.Iterator;

public class CallbackWizard
extends Wizard {
    private CallbackElement m_CallbackElement = null;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CallbackWizard.class);

    public CallbackWizard(CallbackElement callbackElement, boolean bl) {
        super(I18N.ERD.getString("CallbackWizard.title"));
        this.setReadOnly(bl);
        this.m_CallbackElement = callbackElement;
        this.buildPages();
    }

    public CallbackElement getCallbackElement() {
        return this.m_CallbackElement;
    }

    @Override
    public boolean canFinish() {
        IWizardPage iWizardPage = this.getStartingPage();
        if (iWizardPage != null) {
            return iWizardPage.isPageComplete();
        }
        return false;
    }

    @Override
    public boolean performFinish() {
        super.performFinish();
        IWizardPage iWizardPage = this.getStartingPage();
        if (iWizardPage instanceof IFinishPage) {
            ((IFinishPage)iWizardPage).doFinish();
        }
        return true;
    }

    @Override
    public IWizardPage getStartingPage() {
        String string = this.m_CallbackElement.getType();
        if (string == null) {
            return super.getStartingPage();
        }
        return this.getPage(string);
    }

    protected void buildPages() {
        CallbackStartPage callbackStartPage = new CallbackStartPage();
        callbackStartPage.setWizard(this);
        this.m_Pages.add(callbackStartPage);
        Iterator<PageHolder> iterator = WizardRegistry.getPageHolders();
        while (iterator.hasNext()) {
            PageHolder pageHolder = iterator.next();
            try {
                IWizardPage iWizardPage = pageHolder.getPage();
                iWizardPage.setWizard(this);
                this.m_Pages.add(iWizardPage);
            }
            catch (Exception exception) {
                m_Log.warn((Object)("Can't load page " + pageHolder.getPageClassName() + " : " + String.valueOf(exception)));
                exception.printStackTrace();
            }
        }
    }
}

