/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.callback;

import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.CallbackElement;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.IRenderScriptHolder;
import com.elixirtech.ui.ITabComponent;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.wizard.callback.CallbackDataPage;
import com.elixirtech.wizard.callback.CallbackTab;
import com.elixirtech.wizard.callback.CallbackWizard;
import com.elixirtech.wizard.data.IDataPanel;
import com.elixirtech.wizard.tab.ScriptTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentListener;

public class HTMLCallbackPage
extends CallbackDataPage {
    public static void getTabs(CallbackElement callbackElement, List<ITabComponent> list) {
        list.add(new HTMLCallbackPage().new HTMLTab(callbackElement));
        list.add(new ScriptTab((IRenderScriptHolder)callbackElement));
    }

    public HTMLCallbackPage() {
        super("HTML");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        CallbackElement callbackElement = ((CallbackWizard)iWizard).getCallbackElement();
        HTMLTab hTMLTab = new HTMLTab(callbackElement);
        CallbackDataPage.EditorKitPanel editorKitPanel = hTMLTab.getLiteralPanel();
        editorKitPanel.addDocumentListener(this.m_FieldWatcher);
        this.addTab(hTMLTab);
        this.addTab(new ScriptTab((IRenderScriptHolder)callbackElement));
    }

    protected class HTMLTab
    extends CallbackTab {
        public HTMLTab(CallbackElement callbackElement) {
            super(callbackElement);
        }

        @Override
        public String getName() {
            return I18N.ERD.getString("HTMLCallbackPage.name");
        }

        @Override
        public String getMessage() {
            return I18N.ERD.getString("HTMLCallbackPage.message");
        }

        @Override
        protected IDataPanel createLiteralPanel(ControlSource controlSource) {
            if (controlSource.getType().equals("Literal")) {
                return new HTMLEditorKitPanel(controlSource.getText());
            }
            return new HTMLEditorKitPanel("");
        }
    }

    protected class HTMLEditorKitPanel
    extends CallbackDataPage.EditorKitPanel {
        private JEditorPane m_EditorPane;

        public HTMLEditorKitPanel(String string) {
            this.setLayout(new BorderLayout());
            this.m_EditorPane = new JEditorPane();
            this.m_EditorPane.setText(string);
            this.add((Component)new JScrollPane(this.m_EditorPane), "Center");
        }

        @Override
        public String getText() {
            return this.m_EditorPane.getText();
        }

        @Override
        public void addDocumentListener(DocumentListener documentListener) {
            this.m_EditorPane.getDocument().addDocumentListener(documentListener);
        }
    }
}

