/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.callback;

import com.elixirtech.arch.ElixirJ;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.CallbackElement;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.IRenderScriptHolder;
import com.elixirtech.ui.ITabComponent;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.wizard.callback.CallbackDataPage;
import com.elixirtech.wizard.callback.CallbackTab;
import com.elixirtech.wizard.callback.CallbackWizard;
import com.elixirtech.wizard.data.IDataPanel;
import com.elixirtech.wizard.tab.ScriptTab;
import java.io.ByteArrayOutputStream;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;

public class RTFCallbackPage
extends CallbackDataPage {
    public static void getTabs(CallbackElement callbackElement, List<ITabComponent> list) {
        list.add(new RTFCallbackPage().new RTFTab(callbackElement));
        list.add(new ScriptTab((IRenderScriptHolder)callbackElement));
    }

    public RTFCallbackPage() {
        super("RTF");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        CallbackElement callbackElement = ((CallbackWizard)iWizard).getCallbackElement();
        RTFTab rTFTab = new RTFTab(callbackElement);
        CallbackDataPage.EditorKitPanel editorKitPanel = rTFTab.getLiteralPanel();
        editorKitPanel.addDocumentListener(this.m_FieldWatcher);
        this.addTab(rTFTab);
        this.addTab(new ScriptTab((IRenderScriptHolder)callbackElement));
    }

    protected class RTFTab
    extends CallbackTab {
        public RTFTab(CallbackElement callbackElement) {
            super(callbackElement);
        }

        @Override
        public String getName() {
            return I18N.ERD.getString("RTFCallbackPage.name");
        }

        @Override
        public String getMessage() {
            return I18N.ERD.getString("RTFCallbackPage.message");
        }

        @Override
        protected IDataPanel createLiteralPanel(ControlSource controlSource) {
            if (controlSource.getType().equals("Literal")) {
                return new RTFEditorKitPanel(controlSource.getText());
            }
            return new RTFEditorKitPanel("");
        }
    }

    protected class RTFEditorKitPanel
    extends CallbackDataPage.EditorKitPanel {
        public RTFEditorKitPanel(String string) {
            super(new RTFEditorKit());
            this.addToolBarAction(new OpenRTFFileAction());
            this.m_Editor.setText(string);
        }

        @Override
        public String getText() {
            try {
                RTFEditorKit rTFEditorKit = (RTFEditorKit)this.m_Editor.getEditorKit();
                Document document = this.m_Editor.getDocument();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                rTFEditorKit.write(byteArrayOutputStream, document, 0, document.getLength());
                return byteArrayOutputStream.toString();
            }
            catch (Exception exception) {
                ElixirJ.error(I18N.ERD.getString("RTFCallbackPage.error-writing") + String.valueOf(exception), exception);
                return null;
            }
        }

        protected class OpenRTFFileAction
        extends CallbackDataPage.OpenFileAction {
            public OpenRTFFileAction() {
                super(RTFEditorKitPanel.this.m_Editor);
                this.m_ActionName = I18N.ERD.getString("RTFCallbackPage.Action.name");
                this.m_ActionDesc = I18N.ERD.getString("RTFCallbackPage.Action.description");
                this.m_FileDesc = I18N.ERD.getString("RTFCallbackPage.Action.filedescription");
                this.m_FilterBy = "rtf";
                this.m_FilterByDesc = I18N.ERD.getString("RTFCallbackPage.Action.filterby");
                this.init();
            }
        }
    }
}

