/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.callback;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.icons.CallbackIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.CallbackElement;
import com.elixirtech.ui.IRenderable;
import com.elixirtech.ui.ITabComponent;
import com.elixirtech.ui.wizard.PageHolder;
import com.elixirtech.wizard.callback.HTMLCallbackPage;
import com.elixirtech.wizard.callback.RTFCallbackPage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;

public class WizardRegistry {
    private static Set<CallbackType> m_Callbacks = new TreeSet<CallbackType>();
    private static List<PageHolder> m_Pages = new ArrayList<PageHolder>();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(WizardRegistry.class);

    public static void register(CallbackType callbackType) {
        m_Log.info((Object)("registering callback " + callbackType.getName()));
        m_Callbacks.add(callbackType);
    }

    public static CallbackType[] getTypes() {
        CallbackType[] callbackTypeArray = new CallbackType[m_Callbacks.size()];
        m_Callbacks.toArray(callbackTypeArray);
        return callbackTypeArray;
    }

    public static CallbackType getType(String string) {
        for (CallbackType callbackType : m_Callbacks) {
            if (!string.equals(callbackType.getName())) continue;
            return callbackType;
        }
        return null;
    }

    public static void registerPage(Class clazz, String string, String string2, Icon icon) {
        m_Pages.add(new PageHolder(clazz, string, string2, icon));
    }

    public static Iterator<PageHolder> getPageHolders() {
        return m_Pages.iterator();
    }

    static {
        WizardRegistry.register(new RTFCallbackType());
        WizardRegistry.register(new HTMLCallbackType());
    }

    public static abstract class CallbackType
    implements Comparable<Object>,
    IRenderable {
        private Icon m_Icon;
        private String m_Name;
        private String m_Description;

        public CallbackType(String string, String string2) {
            this(string, string2, null);
        }

        public CallbackType(String string, String string2, Icon icon) {
            this.m_Name = string;
            this.m_Description = string2;
            this.m_Icon = icon;
        }

        public abstract void buildTabs(CallbackElement var1, List<ITabComponent> var2);

        @Override
        public int compareTo(Object object) {
            return this.m_Name.compareTo(((CallbackType)object).m_Name);
        }

        public String toString() {
            return this.m_Name;
        }

        @Override
        public String getName() {
            return this.m_Name;
        }

        public String getDescription() {
            return this.m_Description;
        }

        @Override
        public Icon getIcon() {
            return this.m_Icon;
        }
    }

    private static class RTFCallbackType
    extends CallbackType {
        public RTFCallbackType() {
            super("RTF", I18N.ERD.getString("RTFCallbackType.title"), CallbackIcons.RTF);
            WizardRegistry.registerPage(RTFCallbackPage.class, I18N.ERD.getString("RTFCallbackType.title"), I18N.ERD.getString("RTFCallbackType.message"), null);
        }

        @Override
        public void buildTabs(CallbackElement callbackElement, List<ITabComponent> list) {
            RTFCallbackPage.getTabs(callbackElement, list);
        }
    }

    private static class HTMLCallbackType
    extends CallbackType {
        public HTMLCallbackType() {
            super("HTML", I18N.ERD.getString("HTMLCallbackType.title"), CallbackIcons.HTML);
            WizardRegistry.registerPage(HTMLCallbackPage.class, I18N.ERD.getString("HTMLCallbackType.title"), I18N.ERD.getString("HTMLCallbackType.message"), null);
        }

        @Override
        public void buildTabs(CallbackElement callbackElement, List<ITabComponent> list) {
            HTMLCallbackPage.getTabs(callbackElement, list);
        }
    }
}

