/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.chart;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chart2.IChartData;
import com.elixirtech.chart2.IChartHolder;
import com.elixirtech.chart2.IChartWizard;
import com.elixirtech.chart2.ui.AreaPage;
import com.elixirtech.chart2.ui.BarPage;
import com.elixirtech.chart2.ui.BubblePage;
import com.elixirtech.chart2.ui.CandlestickPage;
import com.elixirtech.chart2.ui.ChooseChartPage;
import com.elixirtech.chart2.ui.ColumnPage;
import com.elixirtech.chart2.ui.GanttPage;
import com.elixirtech.chart2.ui.HeatMapXYPage;
import com.elixirtech.chart2.ui.HighLowPage;
import com.elixirtech.chart2.ui.LinePage;
import com.elixirtech.chart2.ui.MeterPage;
import com.elixirtech.chart2.ui.MultiPiePage;
import com.elixirtech.chart2.ui.PiePage;
import com.elixirtech.chart2.ui.PolarPage;
import com.elixirtech.chart2.ui.ThreeDAreaPage;
import com.elixirtech.chart2.ui.ThreeDColumnPage;
import com.elixirtech.chart2.ui.ThreeDLinePage;
import com.elixirtech.chart2.ui.ThreeDScatterPage;
import com.elixirtech.chart2.ui.ThreeDSurfacePage;
import com.elixirtech.chart2.ui.WaterfallPage;
import com.elixirtech.chart2.ui.WindPage;
import com.elixirtech.chart2.ui.WindRosePage;
import com.elixirtech.chart2.ui.XYPage;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.icons.ChartIcons;
import com.elixirtech.jdom.Document;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Chart;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.ui.wizard.Wizard;
import com.elixirtech.util.StringUtil;
import com.elixirtech.wizard.chart.DataSourcePage;
import java.awt.Dimension;

public class ChartWizard
extends Wizard
implements IChartWizard,
IChartHolder,
IChartData {
    private final Chart m_Chart;
    private final RawReport m_Report;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ChartWizard.class);

    public ChartWizard(Chart chart, boolean bl) {
        super(I18N.ERD.getString("ChartWizard.title"));
        m_Log.debug((Object)"Construction");
        this.setReadOnly(bl);
        this.m_Chart = chart;
        Chunk chunk = this.m_Chart.getChunk();
        Section section = chunk.getSection();
        this.m_Report = (RawReport)section.getRawReport();
        this.buildPages();
    }

    @Override
    public boolean isStandardSize() {
        return false;
    }

    @Override
    public Dimension getSize() {
        return new Dimension(550, 480);
    }

    protected void buildPages() {
        m_Log.debug((Object)"Start buildPages");
        this.addPage(new DataSourcePage(this.m_Chart, this.m_Report));
        this.addPage(new ChooseChartPage());
        this.addPage(new AreaPage());
        this.addPage(new BubblePage());
        this.addPage(new BarPage());
        this.addPage(new CandlestickPage());
        this.addPage(new ColumnPage());
        this.addPage(new GanttPage());
        this.addPage(new HeatMapXYPage());
        this.addPage(new HighLowPage());
        this.addPage(new LinePage());
        this.addPage(new MeterPage());
        this.addPage(new MultiPiePage());
        this.addPage(new PiePage());
        this.addPage(new PolarPage());
        this.addPage(new WaterfallPage());
        this.addPage(new XYPage());
        this.addPage(new ThreeDAreaPage());
        this.addPage(new ThreeDColumnPage());
        this.addPage(new ThreeDLinePage());
        this.addPage(new ThreeDScatterPage());
        this.addPage(new ThreeDSurfacePage());
        this.addPage(new WindPage());
        this.addPage(new WindRosePage());
        for (IWizardPage iWizardPage : this.m_Pages) {
            m_Log.debug((Object)("setWizard page: " + iWizardPage.getName()));
            iWizardPage.setWizard(this);
            iWizardPage.setIcon(ChartIcons.CHART_IMAGE);
        }
        m_Log.debug((Object)"End buildPages");
    }

    private void addPage(IWizardPage iWizardPage) {
        m_Log.debug((Object)("Adding page: " + iWizardPage.getName()));
        this.m_Pages.add(iWizardPage);
    }

    @Override
    public boolean canFinish() {
        if (this.isReadOnly()) {
            return false;
        }
        ChooseChartPage chooseChartPage = (ChooseChartPage)this.getPage("ChooseChart");
        return chooseChartPage.isPageComplete();
    }

    public IChartHolder getChartHolder() {
        return this;
    }

    public String getDataSourcePath() {
        DataSourcePage dataSourcePage = (DataSourcePage)this.getPage("DataSource");
        String string = dataSourcePage.getDataSourcePath();
        if (StringUtil.isEmpty(string)) {
            Section section = this.m_Chart.getChunk().getSection();
            String string2 = section.getDataSource();
            DataSource dataSource = section.getResourceProvider().getDataSource(string2);
            if (dataSource != null) {
                string = dataSource.getDataSourceName();
            }
        }
        return string;
    }

    public String getDataSourceRange() {
        DataSourcePage dataSourcePage = (DataSourcePage)this.getPage("DataSource");
        return dataSourcePage.getDataSourceRange();
    }

    public DataSchema getSchema() {
        DataSourcePage dataSourcePage = (DataSourcePage)this.getPage("DataSource");
        return dataSourcePage.getSchema();
    }

    public Document getChartDocument() {
        return this.m_Chart.getDocument();
    }

    public void setChartDocument(Document document) {
        this.m_Chart.setDocument(document);
    }

    public RawReport getReport() {
        return this.m_Report;
    }

    @Override
    public boolean performFinish() {
        super.performFinish();
        ChooseChartPage chooseChartPage = (ChooseChartPage)this.getPage("ChooseChart");
        chooseChartPage.doFinish();
        DataSourcePage dataSourcePage = (DataSourcePage)this.getPage("DataSource");
        dataSourcePage.doFinish();
        return true;
    }
}

