/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.chart;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chart2.IChartData;
import com.elixirtech.chart2.IChartHolder;
import com.elixirtech.chart2.IChartWizard;
import com.elixirtech.chart2.composite.ui.ChartConfigPage;
import com.elixirtech.chart2.composite.ui.ChooseCompositeChartPage;
import com.elixirtech.chart2.composite.ui.SubPlotPage;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.icons.ChartIcons;
import com.elixirtech.jdom.Document;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.CompositeChart;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.ui.wizard.IFinishPage;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.ui.wizard.Wizard;
import com.elixirtech.wizard.chart.ChartWizard;
import com.elixirtech.wizard.chart.IReportInfoProvider;
import java.awt.Dimension;

public class CompositeChartWizard
extends Wizard
implements IChartHolder,
IChartWizard,
IChartData {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ChartWizard.class);
    private IReportInfoProvider m_Report;
    private final CompositeChart m_Chart;

    public CompositeChartWizard(CompositeChart compositeChart, boolean bl) {
        super(I18N.ERD.getString("CompositeChartWizard.title"));
        this.setReadOnly(bl);
        this.m_Chart = compositeChart;
        this.m_Report = new ReportInfo(this.m_Chart);
        this.buildPages();
    }

    @Override
    public boolean isStandardSize() {
        return false;
    }

    @Override
    public Dimension getSize() {
        return new Dimension(550, 480);
    }

    private void buildPages() {
        this.addPage(new ChooseCompositeChartPage());
        this.addPage(new SubPlotPage(ChartConfigPage.NAME));
        this.addPage(new ChartConfigPage());
        for (IWizardPage iWizardPage : this.m_Pages) {
            m_Log.debug((Object)("setWizard page: " + iWizardPage.getName()));
            iWizardPage.setWizard(this);
            iWizardPage.setIcon(ChartIcons.CHART_IMAGE);
        }
    }

    private void addPage(IWizardPage iWizardPage) {
        m_Log.debug((Object)("Adding page: " + iWizardPage.getName()));
        this.m_Pages.add(iWizardPage);
    }

    @Override
    public boolean canFinish() {
        if (this.isReadOnly()) {
            return false;
        }
        IWizardPage iWizardPage = this.getPage("ChooseCompositeChart");
        return iWizardPage.isPageComplete();
    }

    public IChartHolder getChartHolder() {
        return this;
    }

    public CompositeChart getRawChart() {
        return this.m_Chart;
    }

    public Document getChartDocument() {
        return this.m_Chart.getDocument();
    }

    public void setChartDocument(Document document) {
        this.m_Chart.setDocument(document);
    }

    public IReportInfoProvider getReportProvider() {
        return this.m_Report;
    }

    @Override
    public boolean performFinish() {
        int n = this.m_Pages.size();
        for (int i = n - 1; i >= 0; --i) {
            IWizardPage iWizardPage = (IWizardPage)this.m_Pages.get(i);
            if (!(iWizardPage instanceof IFinishPage)) continue;
            ((IFinishPage)iWizardPage).doFinish();
        }
        super.performFinish();
        return true;
    }

    public String getDataSourcePath() {
        String string = this.m_Report.getSection().getDataSource();
        DataSource dataSource = this.m_Report.getRawReport().getDataSource(string);
        if (dataSource != null) {
            return dataSource.getDataSourceName();
        }
        return null;
    }

    public String getDataSourceRange() {
        return null;
    }

    public DataSchema getSchema() {
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        String string = this.m_Report.getSection().getDataSource();
        DataSource dataSource = this.m_Report.getRawReport().getDataSource(string);
        if (dataSource != null) {
            try {
                IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, dataSource.getDataSourceName());
                return iDataSource.getSchema();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return null;
    }

    public class ReportInfo
    implements IReportInfoProvider {
        private Section m_Section;
        private RawReport m_RawReport;
        private Chunk m_Chunk;

        public ReportInfo(CompositeChart compositeChart) {
            this.m_Chunk = compositeChart.getChunk();
            this.m_Section = this.m_Chunk.getSection();
            this.m_RawReport = (RawReport)this.m_Section.getRawReport();
            assert (this.m_RawReport != null);
        }

        @Override
        public Chunk getChunk() {
            return this.m_Chunk;
        }

        @Override
        public RawReport getRawReport() {
            return this.m_RawReport;
        }

        @Override
        public Section getSection() {
            return this.m_Section;
        }
    }
}

