/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.cube;

import com.elixirtech.ensemble.canvas.SortNode;
import com.elixirtech.ensemble.cube.ICubeWrapper;
import com.elixirtech.report2.I18N;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.WizardPage;
import com.elixirtech.wizard.cube.AxesPanel;
import com.elixirtech.wizard.cube.ICubeWizard;
import com.elixirtech.wizard.cube.MeasurePage;
import java.awt.BorderLayout;
import javax.swing.BorderFactory;

public class AxisPage
extends WizardPage {
    public static final String NAME = "Axis";
    private ICubeWrapper m_ICube;
    private AxesPanel m_AxesPanel;

    public AxisPage() {
        super(NAME, "Measure");
        I18N.ERD_MAP.injectObject(null, this, "AxisPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_ICube = ((ICubeWizard)((Object)iWizard)).getCube();
        this.buildComponent();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.m_AxesPanel.setVisible(bl);
    }

    public void performFinish() {
        if (this.m_AxesPanel.isInitialized()) {
            this.m_ICube.setCubeRows(this.m_AxesPanel.getRowDimensions());
            this.m_ICube.setCubeColumns(this.m_AxesPanel.getColumnDimensions());
        }
    }

    @Override
    public boolean canFlipToNextPage() {
        return true;
    }

    @Override
    public boolean isPageComplete() {
        MeasurePage measurePage = (MeasurePage)this.m_Wizard.getPage("Measure");
        if (measurePage != null) {
            return measurePage.getMeasureCount() > 0;
        }
        return true;
    }

    protected void buildComponent() {
        this.m_Component.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.m_Component.setLayout(new BorderLayout());
        this.m_AxesPanel = new AxesPanel(this.m_Wizard, this.m_ICube);
        if (this.m_ICube.isReadOnly()) {
            this.m_AxesPanel.setEnabled(false);
        }
        this.m_Component.add(this.m_AxesPanel);
    }

    protected SortNode[] getRowDimensions() {
        return this.m_AxesPanel.getRowDimensions();
    }

    protected SortNode[] getColumnDimensions() {
        return this.m_AxesPanel.getColumnDimensions();
    }
}

