/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.cube;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.IFunctionFactory;
import com.elixirtech.data2.olap.CubeHelper;
import com.elixirtech.data2.olap.Dimension;
import com.elixirtech.data2.olap.Hierarchy;
import com.elixirtech.data2.olap.IDimension;
import com.elixirtech.data2.olap.Level;
import com.elixirtech.data2.olap.Measure;
import com.elixirtech.ensemble.canvas.SortNode;
import com.elixirtech.ensemble.cube.ICubeWrapper;
import com.elixirtech.ensemble.cube.IMeasure;
import com.elixirtech.ensemble.wizard.result.ResultSchemaPanel;
import com.elixirtech.report2.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardContainer;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.ui.wizard.WizardPage;
import com.elixirtech.wizard.cube.AxisPage;
import com.elixirtech.wizard.cube.CubeInfo;
import com.elixirtech.wizard.cube.FlagsPage;
import com.elixirtech.wizard.cube.HierarchyPage;
import com.elixirtech.wizard.cube.HierarchyPanel;
import com.elixirtech.wizard.cube.ICubeWizard;
import com.elixirtech.wizard.cube.LevelChoice;
import com.elixirtech.wizard.cube.MeasurePage;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;

public class CachePage
extends WizardPage
implements ActionListener,
ItemListener {
    public static final String NAME = "Cache";
    private ICubeWrapper m_ICube;
    private ArchLayout m_Layout;
    private JButton m_Infer;
    ResultSchemaPanel m_SchemaPanel;
    DataSchema m_CubeSchema;

    public CachePage() {
        super(NAME, null);
        I18N.ERD_MAP.injectObject(null, this, "CubeCachePage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_ICube = ((ICubeWizard)((Object)iWizard)).getCube();
        this.m_CubeSchema = this.m_ICube.getCachedSchema();
        this.buildComponent();
    }

    public void performFinish() {
        this.m_ICube.setCachedSchema(this.m_CubeSchema);
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public IWizardPage getNextPage() {
        return null;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.updateButtons();
            Set<String> set = this.m_SchemaPanel.getDiscardSet();
            this.m_SchemaPanel.setSchema(this.m_CubeSchema, set);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        CubeInfo cubeInfo;
        String string;
        int n;
        DataSchema dataSchema = this.m_ICube.getDataSchema();
        IFunctionFactory iFunctionFactory = (IFunctionFactory)Elixir.get(IFunctionFactory.class);
        AxisPage axisPage = (AxisPage)this.m_Wizard.getPage("Axis");
        MeasurePage measurePage = (MeasurePage)this.m_Wizard.getPage("Measure");
        FlagsPage flagsPage = (FlagsPage)this.m_Wizard.getPage("Flags");
        IDimension[] iDimensionArray = this.buildDimensions(axisPage.getRowDimensions());
        IDimension[] iDimensionArray2 = this.buildDimensions(axisPage.getColumnDimensions());
        IMeasure[] iMeasureArray = measurePage.getMeasures();
        Measure[] measureArray = new Measure[iMeasureArray.length];
        for (n = 0; n < measureArray.length; ++n) {
            string = iMeasureArray[n].getName();
            int n2 = dataSchema.getColumnIndex(string);
            cubeInfo = iFunctionFactory.getFunction(CubeHelper.CUBE_DATA_TYPE, iMeasureArray[n].getFunction());
            String string2 = iMeasureArray[n].getPattern();
            measureArray[n] = new Measure(string, n2, (Function)cubeInfo, string2);
        }
        n = 0;
        string = "All";
        String string3 = "All";
        if (flagsPage != null) {
            n = flagsPage.isKeepColumnTotals() ? 1 : 0;
            string = flagsPage.getRowTitle();
            string3 = flagsPage.getColumnTitle();
        }
        cubeInfo = new CubeInfo(iDimensionArray, iDimensionArray2, measureArray);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateButtons();
    }

    protected IDimension[] buildDimensions(SortNode[] sortNodeArray) {
        HierarchyPage hierarchyPage = (HierarchyPage)this.m_Wizard.getPage("Dimension");
        IDimension[] iDimensionArray = new IDimension[sortNodeArray.length];
        for (int i = 0; i < sortNodeArray.length; ++i) {
            Hierarchy hierarchy;
            if (this.isHierarchy(sortNodeArray[i].getName())) {
                hierarchy = new Hierarchy(sortNodeArray[i].getName());
                HierarchyPanel.Dimension dimension = hierarchyPage.getHierarchy(sortNodeArray[i].getName());
                for (int j = 0; j < dimension.path.length; ++j) {
                    LevelChoice levelChoice = dimension.path[j];
                    hierarchy.addLevel(new Level(levelChoice.getName(), levelChoice.getSortOrder(), levelChoice.getGroupOn(), levelChoice.getGroupData(), levelChoice.getDerivedField()));
                }
                iDimensionArray[i] = hierarchy;
                continue;
            }
            hierarchy = new Level(sortNodeArray[i].getName(), sortNodeArray[i].getSortOrder(), sortNodeArray[i].getGroupOn(), sortNodeArray[i].getGroupData(), null);
            iDimensionArray[i] = new Dimension((Level)hierarchy);
        }
        return iDimensionArray;
    }

    protected boolean isHierarchy(String string) {
        HierarchyPage hierarchyPage = (HierarchyPage)this.m_Wizard.getPage("Dimension");
        return hierarchyPage.isHierarchy(string);
    }

    protected void buildComponent() {
        this.m_Component.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.m_Layout = new ArchLayout();
        this.m_Component.setLayout(this.m_Layout);
        this.m_Infer = SwingFactory.newButton("infer");
        this.m_Infer.addActionListener(this);
        this.m_Component.add("infer", this.m_Infer);
        this.m_SchemaPanel = new ResultSchemaPanel(true);
        this.m_Component.add("schema", this.m_SchemaPanel);
        this.m_Layout.hCenter("infer");
        this.m_Layout.stickTop("infer");
        this.m_Layout.stickLeft("schema");
        this.m_Layout.stickRight("schema");
        this.m_Layout.putBelow("schema", "infer", 3);
        this.m_Layout.stickBottom("schema");
        I18N.ERD_MAP.injectComponents("CubeCachePage.", this.m_Component);
        this.updateButtons();
    }

    protected void updateButtons() {
        IWizardContainer iWizardContainer;
        MeasurePage measurePage = (MeasurePage)this.m_Wizard.getPage("Measure");
        DataSchema dataSchema = this.m_ICube.getDataSchema();
        int n = measurePage.getMeasureCount();
        IViewModel iViewModel = (IViewModel)Elixir.get(IViewModel.class);
        IPanelView iPanelView = iViewModel != null ? iViewModel.getCurrentView() : null;
        this.m_Infer.setEnabled(false);
        if (n == 0) {
            this.setError("No measures defined");
        }
        if ((iWizardContainer = this.m_Wizard.getContainer()) != null) {
            iWizardContainer.updateMessage();
        }
    }
}

