/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.cube;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.ensemble.cube.ICubeWrapper;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.CubeTable;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.Wizard;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.util.StringUtil;
import com.elixirtech.wizard.cube.CubeTableWrapper;
import com.elixirtech.wizard.cube.CubeWizard;
import com.elixirtech.wizard.cube.FlagsPage;
import com.elixirtech.wizard.util.WizardUtil;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;

public class CubeTab
extends TabComponent {
    private CubeTable m_Cube;
    private ArchLayout m_Layout;
    private JComboBox m_DataSources;
    private JRadioButton m_OverAll;
    private JRadioButton m_OverGroup;
    private JRadioButton m_OverRecord;
    private JCheckBox m_ShowColumnHeaders;
    private JCheckBox m_ShowRowHeaders;
    private JButton m_OpenWizard;

    public CubeTab(CubeTable cubeTable) {
        this.m_Cube = cubeTable;
        this.m_Layout = new ArchLayout();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(this.m_Layout);
        this.add(SwingFactory.newLabel("DS.label"));
        this.m_DataSources = SwingFactory.newComboBox("ds", this.getDataSources());
        this.add(this.m_DataSources);
        this.m_DataSources.setEditable(true);
        this.m_OpenWizard = SwingFactory.newButton("open", new CodeBlock((Object)this, "openCubeWizard"));
        this.add(SwingFactory.newButton("DS.add", new CodeBlock((Object)this, "addDataSource")));
        this.m_OverAll = SwingFactory.newRadioButton("DSGROUP.over-all");
        this.add(this.m_OverAll);
        this.m_OverGroup = SwingFactory.newRadioButton("DSGROUP.over-group");
        this.add(this.m_OverGroup);
        this.m_OverRecord = SwingFactory.newRadioButton("DSGROUP.over-record");
        this.add(this.m_OverRecord);
        this.m_ShowColumnHeaders = SwingFactory.newCheckBox("showcolheaders");
        this.add(this.m_ShowColumnHeaders);
        this.m_ShowRowHeaders = SwingFactory.newCheckBox("showrowheaders");
        this.add(this.m_ShowRowHeaders);
        this.add(this.m_OpenWizard);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_OverAll);
        buttonGroup.add(this.m_OverGroup);
        buttonGroup.add(this.m_OverRecord);
        this.m_Layout.stickLeft("DS.label");
        this.m_Layout.vCenter("DS.label", "ds");
        this.m_Layout.stickTop("ds");
        this.m_Layout.putRight("ds", "DS.label", 10);
        this.m_Layout.stickTop("DS.add");
        this.m_Layout.stickRight("DS.add");
        this.m_Layout.setHeight("DS.add", "ds");
        this.m_Layout.putLeft("ds", "DS.add");
        this.m_Layout.alignBelow("DSGROUP.over-all", "ds");
        this.m_Layout.putRight("DSGROUP.over-group", "DSGROUP.over-all", 10);
        this.m_Layout.vCenter("DSGROUP.over-group", "DSGROUP.over-all");
        this.m_Layout.putRight("DSGROUP.over-record", "DSGROUP.over-group", 10);
        this.m_Layout.vCenter("DSGROUP.over-record", "DSGROUP.over-group");
        this.m_Layout.alignBelow("showcolheaders", "DSGROUP.over-all", 5);
        this.m_Layout.alignBelow("showrowheaders", "showcolheaders");
        this.m_Layout.putBelow("open", "showrowheaders", 10);
        this.m_Layout.hCenter("open");
        this.m_DataSources.setSelectedItem(this.m_Cube.getCache());
        String string = this.m_Cube.getDataRange();
        if ("Group".equals(string)) {
            this.m_OverGroup.setSelected(true);
        } else if ("Record".equals(string)) {
            this.m_OverRecord.setSelected(true);
        } else {
            this.m_OverAll.setSelected(true);
        }
        this.m_ShowColumnHeaders.setSelected(this.m_Cube.isShowColumnHeaders());
        this.m_ShowRowHeaders.setSelected(this.m_Cube.isShowRowHeaders());
        I18N.ERD_MAP.injectComponents("CubeTab.", this);
    }

    public void openCubeWizard() {
        Object object;
        Object object2;
        Object object3;
        DataSchema dataSchema = null;
        String string = (String)this.m_DataSources.getSelectedItem();
        if (StringUtil.notEmpty(string)) {
            DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
            try {
                object3 = (RawReport)this.m_Cube.getResourceProvider();
                object2 = object3.getDataSource(string);
                object = dataSourceManager.getDataSource(dataSourceManager, object2.getDataSourceName());
                dataSchema = object.getSchema();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        boolean bl = !this.m_OverAll.isEnabled();
        object3 = new CubeTableWrapper(this.m_Cube, bl);
        ((CubeTableWrapper)object3).setDataSchema(dataSchema);
        object2 = new CubeWizard((ICubeWrapper)object3);
        object = (FlagsPage)((Wizard)object2).getPage("Flags");
        ((FlagsPage)object).setNextPage(null);
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        elixirFrame.showWizard((IWizard)object2);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
        this.m_OpenWizard.setEnabled(true);
    }

    @Override
    public String getName() {
        return I18N.ERD.getString("CubeTab.name");
    }

    @Override
    public String getMessage() {
        return I18N.ERD.getString("CubeTab.message");
    }

    @Override
    public void performFinish() {
        String string = (String)this.m_DataSources.getSelectedItem();
        if (!string.equals(this.m_Cube.getCache())) {
            this.m_Cube.setCache(string);
        }
        if (this.m_OverAll.isSelected()) {
            this.m_Cube.setDataRange("All");
        } else if (this.m_OverGroup.isSelected()) {
            this.m_Cube.setDataRange("Group");
        } else {
            this.m_Cube.setDataRange("Record");
        }
        this.m_Cube.setShowColumnHeaders(this.m_ShowColumnHeaders.isSelected());
        this.m_Cube.setShowRowHeaders(this.m_ShowRowHeaders.isSelected());
    }

    private String[] getDataSources() {
        RawReport rawReport = (RawReport)this.m_Cube.getResourceProvider();
        return WizardUtil.getDataSourceNames(rawReport);
    }

    public void addDataSource() {
        RawReport rawReport = (RawReport)this.m_Cube.getResourceProvider();
        WizardUtil.addDS(rawReport, this.m_DataSources);
    }
}

