/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.cube;

import com.elixirtech.data2.DataSchema;
import com.elixirtech.ensemble.canvas.DimensionNode;
import com.elixirtech.ensemble.canvas.InOutGO;
import com.elixirtech.ensemble.canvas.SortNode;
import com.elixirtech.ensemble.cube.ICubeWrapper;
import com.elixirtech.ensemble.cube.IMeasure;
import com.elixirtech.report2.raw.model.CubeColumn;
import com.elixirtech.report2.raw.model.CubeHierarchy;
import com.elixirtech.report2.raw.model.CubeLevel;
import com.elixirtech.report2.raw.model.CubeMeasure;
import com.elixirtech.report2.raw.model.CubeRow;
import com.elixirtech.report2.raw.model.CubeTable;
import java.awt.Color;

public class CubeTableWrapper
implements ICubeWrapper {
    private CubeTable m_CubeTable;
    private DataSchema m_Schema;
    private DataSchema m_CachedSchema;
    private boolean m_IsReadOnly;

    public CubeTableWrapper(CubeTable cubeTable, boolean bl) {
        this.m_CubeTable = cubeTable;
        this.m_IsReadOnly = bl;
    }

    public CubeTable getCubeTable() {
        return this.m_CubeTable;
    }

    public boolean hasIdentifier() {
        return false;
    }

    public boolean isReadOnly() {
        return this.m_IsReadOnly;
    }

    public DataSchema getCachedSchema() {
        return this.m_CachedSchema;
    }

    public void setCachedSchema(DataSchema dataSchema) {
        this.m_CachedSchema = dataSchema;
    }

    public void setDirty() {
    }

    public DataSchema getDataSchema() {
        return this.m_Schema;
    }

    public void setDataSchema(DataSchema dataSchema) {
        this.m_Schema = dataSchema;
    }

    public String getText() {
        return null;
    }

    public void setText(String string) {
    }

    public Color getFillColor() {
        return null;
    }

    public void setFillColor(Color color) {
    }

    public void removeAllDimensions() {
        this.m_CubeTable.removeAllHierarchys();
    }

    public void addDimension(String string, SortNode[] sortNodeArray) {
        CubeHierarchy cubeHierarchy = new CubeHierarchy();
        cubeHierarchy.setName(string);
        for (int i = 0; i < sortNodeArray.length; ++i) {
            CubeLevel cubeLevel = CubeTableWrapper.asCubeLevel(sortNodeArray[i]);
            cubeHierarchy.addLevel(cubeLevel);
        }
        this.m_CubeTable.addHierarchy(cubeHierarchy);
    }

    public int getDimensionCount() {
        return this.m_CubeTable.getHierarchyCount();
    }

    public DimensionNode getDimension(int n) {
        CubeHierarchy cubeHierarchy = this.m_CubeTable.getHierarchy(n);
        SortNode[] sortNodeArray = new SortNode[cubeHierarchy.getLevelCount()];
        for (int i = 0; i < sortNodeArray.length; ++i) {
            sortNodeArray[i] = CubeTableWrapper.asSortNode(cubeHierarchy.getLevel(i));
        }
        return new DimensionNode(cubeHierarchy.getName(), sortNodeArray);
    }

    public InOutGO getInput() {
        return null;
    }

    public SortNode[] getCubeRows() {
        CubeRow cubeRow = this.m_CubeTable.getRow();
        if (cubeRow == null) {
            return new SortNode[0];
        }
        int n = cubeRow.getItemCount();
        SortNode[] sortNodeArray = new SortNode[n];
        for (int i = 0; i < n; ++i) {
            sortNodeArray[i] = CubeTableWrapper.asSortNode(cubeRow.getItem(i));
        }
        return sortNodeArray;
    }

    public SortNode[] getCubeColumns() {
        CubeColumn cubeColumn = this.m_CubeTable.getColumn();
        if (cubeColumn == null) {
            return new SortNode[0];
        }
        int n = cubeColumn.getItemCount();
        SortNode[] sortNodeArray = new SortNode[n];
        for (int i = 0; i < n; ++i) {
            sortNodeArray[i] = CubeTableWrapper.asSortNode(cubeColumn.getItem(i));
        }
        return sortNodeArray;
    }

    public void setCubeRows(SortNode[] sortNodeArray) {
        CubeRow cubeRow = this.m_CubeTable.getRow();
        if (cubeRow == null) {
            cubeRow = new CubeRow();
            this.m_CubeTable.setRow(cubeRow);
        } else {
            cubeRow.removeAllItems();
        }
        for (int i = 0; i < sortNodeArray.length; ++i) {
            CubeLevel cubeLevel = CubeTableWrapper.asCubeLevel(sortNodeArray[i]);
            cubeRow.addItem(cubeLevel);
        }
    }

    public void setCubeColumns(SortNode[] sortNodeArray) {
        CubeColumn cubeColumn = this.m_CubeTable.getColumn();
        if (cubeColumn == null) {
            cubeColumn = new CubeColumn();
            this.m_CubeTable.setColumn(cubeColumn);
        } else {
            cubeColumn.removeAllItems();
        }
        for (int i = 0; i < sortNodeArray.length; ++i) {
            CubeLevel cubeLevel = CubeTableWrapper.asCubeLevel(sortNodeArray[i]);
            cubeColumn.addItem(cubeLevel);
        }
    }

    public void removeAllMeasures() {
        this.m_CubeTable.removeAllMeasures();
    }

    public void addMeasure(IMeasure iMeasure) {
        if (iMeasure instanceof CubeMeasure) {
            this.m_CubeTable.addMeasure((CubeMeasure)iMeasure);
        } else {
            this.m_CubeTable.addMeasure(new CubeMeasure(iMeasure.getName(), iMeasure.getFunction(), iMeasure.getPattern()));
        }
    }

    public int getMeasureCount() {
        return this.m_CubeTable.getMeasureCount();
    }

    public IMeasure getMeasure(int n) {
        return this.m_CubeTable.getMeasure(n);
    }

    public void setCollapseRows(boolean bl) {
        this.m_CubeTable.setCollapseRows(bl);
    }

    public boolean isCollapseRows() {
        return this.m_CubeTable.isCollapseRows();
    }

    public void setCollapseColumns(boolean bl) {
        this.m_CubeTable.setCollapseColumns(bl);
    }

    public boolean isCollapseColumns() {
        return this.m_CubeTable.isCollapseColumns();
    }

    public boolean canControlTotals() {
        return true;
    }

    public boolean canShowRowHeaderLabels() {
        return true;
    }

    public void setShowRowHeaderLabels(boolean bl) {
        this.m_CubeTable.setShowRowHeaderLabels(bl);
    }

    public boolean isShowRowHeaderLabels() {
        return this.m_CubeTable.isShowRowHeaderLabels();
    }

    public void setKeepRowTotals(boolean bl) {
        this.m_CubeTable.setKeepRowTotals(bl);
    }

    public boolean isKeepRowTotals() {
        return this.m_CubeTable.isKeepRowTotals();
    }

    public void setKeepColumnTotals(boolean bl) {
        this.m_CubeTable.setKeepColumnTotals(bl);
    }

    public boolean isKeepColumnTotals() {
        return this.m_CubeTable.isKeepColumnTotals();
    }

    public void setShowColumnTotalsAfterDetails(boolean bl) {
        this.m_CubeTable.setShowColumnTotalsAfterDetails(bl);
    }

    public boolean isShowColumnTotalsAfterDetails() {
        return this.m_CubeTable.isShowColumnTotalsAfterDetails();
    }

    public void setShowRowTotalsAfterDetails(boolean bl) {
        this.m_CubeTable.setShowRowTotalsAfterDetails(bl);
    }

    public boolean isShowRowTotalsAfterDetails() {
        return this.m_CubeTable.isShowRowTotalsAfterDetails();
    }

    public void setRowTitle(String string) {
        this.m_CubeTable.getRow().setTitle(string);
    }

    public void setColumnTitle(String string) {
        this.m_CubeTable.getColumn().setTitle(string);
    }

    public String getRowTitle() {
        return this.m_CubeTable.getRow().getTitle();
    }

    public String getColumnTitle() {
        return this.m_CubeTable.getColumn().getTitle();
    }

    public static CubeLevel asCubeLevel(SortNode sortNode) {
        CubeLevel cubeLevel = new CubeLevel(sortNode.getName());
        cubeLevel.setSort(sortNode.getSortOrder());
        cubeLevel.setGroupOn(sortNode.getGroupOn());
        cubeLevel.setGroupData(sortNode.getGroupData());
        cubeLevel.setDerivedField(sortNode.getDerivedField());
        cubeLevel.setHideTotals(!sortNode.isShowTotals());
        cubeLevel.setTotalTitle(sortNode.getTotalTitle());
        return cubeLevel;
    }

    public static SortNode asSortNode(CubeLevel cubeLevel) {
        SortNode sortNode = new SortNode();
        sortNode.setName(cubeLevel.getName());
        sortNode.setSortOrder(cubeLevel.getSort());
        sortNode.setGroupOn(cubeLevel.getGroupOn());
        sortNode.setGroupData(cubeLevel.getGroupData());
        sortNode.setDerivedField(cubeLevel.getDerivedField());
        sortNode.setTotalTitle(cubeLevel.getTotalTitle());
        sortNode.setShowTotals(!cubeLevel.isHideTotals());
        sortNode.setTotalTitle(cubeLevel.getTotalTitle());
        return sortNode;
    }

    public String getColumnTotalsTitle() {
        return this.m_CubeTable.getColumnTotalsTitle();
    }

    public void setColumnTotalsTitle(String string) {
        this.m_CubeTable.setColumnTotalsTitle(string);
    }

    public String getRowTotalsTitle() {
        return this.m_CubeTable.getRowTotalsTitle();
    }

    public void setRowTotalsTitle(String string) {
        this.m_CubeTable.setRowTotalsTitle(string);
    }

    public boolean isShowUITitles() {
        return true;
    }
}

